/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.binary;

import io.github.mmm.binary.Streamable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;

public class StreamablePath
implements Streamable {
    private final Path file;

    public StreamablePath(Path file) {
        Objects.requireNonNull(file, "file");
        assert (Files.isRegularFile(file, new LinkOption[0]));
        this.file = file;
    }

    public Path getFile() {
        return this.file;
    }

    @Override
    public void save(OutputStream out) {
        try {
            Files.copy(this.file, out);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public InputStream asStream() {
        try {
            return Files.newInputStream(this.file, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

