/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.binary.codec;

import io.github.mmm.binary.Binary;
import io.github.mmm.binary.codec.BaseFormat;
import io.github.mmm.binary.codec.BaseFormatCodec;
import io.github.mmm.binary.codec.BinaryCodec;
import java.util.Objects;

public abstract class Base
implements BinaryCodec {
    private final String alphabet;

    public Base(String alphabet) {
        Objects.requireNonNull(alphabet, "alphabet");
        this.alphabet = alphabet;
    }

    public String getAlphabet() {
        return this.alphabet;
    }

    public abstract boolean isCaseSensitive();

    @Override
    public final String encode(byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return "";
        }
        return this.doEncode(data, BaseFormat.DEFAULT);
    }

    protected abstract String doEncode(byte[] var1, BaseFormat var2);

    @Override
    public final byte[] decode(String encodedData) {
        if (encodedData == null) {
            return null;
        }
        if (encodedData.isEmpty()) {
            return Binary.EMPTY_BYTE_ARRAY;
        }
        return this.doDecode(encodedData, BaseFormat.DEFAULT);
    }

    protected abstract byte[] doDecode(String var1, BaseFormat var2);

    static RuntimeException illegalCharacter(char c) {
        return Base.illegalCharacter(c, -1);
    }

    static RuntimeException illegalCharacter(char c, int index) {
        return Base.illegalCharacter("Illegal", c, index);
    }

    static RuntimeException illegalCharacter(String errorType, char c, int index) {
        StringBuilder sb = new StringBuilder(40);
        sb.append(errorType);
        sb.append(" character '");
        sb.append(c);
        sb.append("' (#");
        sb.append(Integer.toHexString(c));
        sb.append(')');
        if (index >= 0) {
            sb.append(" at index ");
            sb.append(index);
        }
        sb.append('!');
        throw new IllegalArgumentException(sb.toString());
    }

    public BinaryCodec withFormat(BaseFormat format) {
        return new BaseFormatCodec(this, format);
    }

    public String toString() {
        return "Base" + this.alphabet.length() + "[" + this.alphabet + "]";
    }
}

