/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.binary.codec;

import java.util.Objects;

public class BaseFormat {
    private static final String CRLF = "\r\n";
    private static final char NUL = '\u0000';
    static final BaseFormat DEFAULT = new BaseFormat(null, 0, false, null);
    static final BaseFormat MIME = new BaseFormat("\r\n", 76, false, null);
    static final BaseFormat STRICT = new BaseFormat(null, 0, true, Boolean.TRUE);
    final String newline;
    final int charsPerLine;
    final boolean failOnWhitespace;
    final Boolean padding;
    private final char newline1;
    private final char newline2;
    private final int newlineLength;

    protected BaseFormat(String newline, int charsPerLine, boolean failOnWhitespace, Boolean padding) {
        char nl1 = '\u0000';
        char nl2 = '\u0000';
        if (newline == null) {
            assert (charsPerLine == 0);
            this.newline = null;
            this.charsPerLine = 0;
            this.newlineLength = 0;
        } else {
            if (charsPerLine <= 1) {
                throw new IllegalArgumentException("charsPerLine=" + charsPerLine);
            }
            assert (charsPerLine > 10);
            this.newline = newline;
            this.charsPerLine = charsPerLine;
            this.newlineLength = newline.length();
            if (this.newlineLength == 1) {
                nl1 = newline.charAt(0);
            } else if (this.newlineLength == 2) {
                nl1 = newline.charAt(0);
                nl2 = newline.charAt(1);
            }
        }
        this.newline1 = nl1;
        this.newline2 = nl2;
        this.failOnWhitespace = failOnWhitespace;
        this.padding = padding;
    }

    public String getNewline() {
        return this.newline;
    }

    public int getCharsPerLine() {
        return this.charsPerLine;
    }

    public boolean isFailOnWhitespace() {
        return this.failOnWhitespace;
    }

    public boolean isFailOnMissingPadding() {
        return Boolean.TRUE.equals(this.padding);
    }

    public boolean isOmitPadding() {
        return Boolean.FALSE.equals(this.padding);
    }

    void appendNewline(char[] chars, int index) {
        if (this.newlineLength > 0) {
            if (this.newlineLength > 2) {
                for (int i = 0; i < this.newlineLength; ++i) {
                    chars[index + i] = this.newline.charAt(i);
                }
            } else {
                chars[index] = this.newline1;
                if (this.newlineLength == 2) {
                    chars[index + 1] = this.newline2;
                }
            }
        }
    }

    public static BaseFormat ofDefault() {
        return DEFAULT;
    }

    public static BaseFormat ofMime() {
        return MIME;
    }

    public static BaseFormat ofStrict() {
        return STRICT;
    }

    public static BaseFormat ofNewline(String newline, int charsPerLine) {
        Objects.requireNonNull(newline, "newline");
        if (!newline.trim().isEmpty()) {
            throw new IllegalArgumentException("Illegal newline '" + newline + "' - shall only contain whitespace characters.");
        }
        return new BaseFormat(newline, charsPerLine, true, null);
    }
}

