/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.binary.codec;

import io.github.mmm.binary.Binary;
import io.github.mmm.binary.codec.Base;
import io.github.mmm.binary.codec.BaseFormat;
import io.github.mmm.binary.codec.BinaryCodec;
import java.util.Objects;

public class BaseFormatCodec
implements BinaryCodec {
    private final Base base;
    private final BaseFormat format;

    public BaseFormatCodec(Base base, BaseFormat format) {
        Objects.requireNonNull(base, "base");
        Objects.requireNonNull(format, "format");
        this.base = base;
        this.format = format;
    }

    @Override
    public String encode(byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return "";
        }
        return this.base.doEncode(data, this.format);
    }

    @Override
    public byte[] decode(String encodedData) {
        if (encodedData == null) {
            return null;
        }
        if (encodedData.isEmpty()) {
            return Binary.EMPTY_BYTE_ARRAY;
        }
        return this.base.doDecode(encodedData, this.format);
    }
}

