/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.binary.codec;

import io.github.mmm.binary.codec.Base;
import io.github.mmm.binary.codec.BaseFormat;
import io.github.mmm.binary.codec.BitConfig;
import io.github.mmm.binary.codec.CoderConfig;
import io.github.mmm.binary.codec.CoderConfigDivMod;
import io.github.mmm.binary.codec.CoderConfigPowerOfTwo;

public class BaseGeneric
extends Base {
    static final char NUL = '\u0000';
    private final CoderConfig config;

    public BaseGeneric(String alphabet) {
        this(alphabet, '=');
    }

    public BaseGeneric(String alphabet, char paddingChar) {
        super(alphabet);
        this.config = this.createConfig(alphabet, paddingChar);
    }

    protected CoderConfig createConfig(String alphabet, char paddingChar) {
        int length = alphabet.length();
        if (length < 2 || length > 107) {
            throw new IllegalArgumentException(alphabet);
        }
        BitConfig bitConfig = BitConfig.of(length);
        if (bitConfig == null) {
            return new CoderConfigDivMod(alphabet);
        }
        return new CoderConfigPowerOfTwo(alphabet, bitConfig, paddingChar);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.config.isCaseSensitive();
    }

    @Override
    protected String doEncode(byte[] data, BaseFormat format) {
        return this.config.encode(data, format);
    }

    @Override
    protected byte[] doDecode(String encodedData, BaseFormat format) {
        return this.config.decode(encodedData, format);
    }
}

