/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.binary.codec;

public interface BinaryCodec {
    public String encode(byte[] var1);

    default public String encodeShort(short value) {
        byte[] data = new byte[]{(byte)(value >> 8), (byte)value};
        return this.encode(data);
    }

    default public String encodeInt(int value) {
        byte[] data = new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        return this.encode(data);
    }

    default public String encodeLong(long value) {
        byte[] data = new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        return this.encode(data);
    }

    public byte[] decode(String var1);

    default public short decodeShort(String encodedData) {
        byte[] data = this.decode(encodedData);
        if (data.length == 2) {
            return (short)((data[0] & 0xFF) << 8 | data[1] & 0xFF);
        }
        if (data.length == 1) {
            return data[0];
        }
        throw new IllegalArgumentException("Decoded data has invalid length " + data.length);
    }

    default public int decodeInt(String encodedData) {
        byte[] data = this.decode(encodedData);
        if (data.length == 4) {
            return (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        }
        if (data.length == 3) {
            return (data[0] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[2] & 0xFF;
        }
        if (data.length == 2) {
            return (data[0] & 0xFF) << 8 | data[1] & 0xFF;
        }
        if (data.length == 1) {
            return data[0];
        }
        throw new IllegalArgumentException("Decoded data has invalid length " + data.length);
    }

    default public long decodeLong(String encodedData) {
        byte[] data = this.decode(encodedData);
        if (data.length == 8) {
            return (long)data[0] << 56 | ((long)data[1] & 0xFFL) << 48 | ((long)data[2] & 0xFFL) << 40 | ((long)data[3] & 0xFFL) << 32 | ((long)data[4] & 0xFFL) << 24 | ((long)data[5] & 0xFFL) << 16 | ((long)data[6] & 0xFFL) << 8 | (long)data[7] & 0xFFL;
        }
        if (data.length == 7) {
            return ((long)data[0] & 0xFFL) << 48 | ((long)data[1] & 0xFFL) << 40 | ((long)data[2] & 0xFFL) << 32 | ((long)data[3] & 0xFFL) << 24 | ((long)data[4] & 0xFFL) << 16 | ((long)data[5] & 0xFFL) << 8 | (long)data[6] & 0xFFL;
        }
        if (data.length == 6) {
            return ((long)data[0] & 0xFFL) << 40 | ((long)data[1] & 0xFFL) << 32 | ((long)data[2] & 0xFFL) << 24 | ((long)data[3] & 0xFFL) << 16 | ((long)data[4] & 0xFFL) << 8 | (long)data[5] & 0xFFL;
        }
        if (data.length == 5) {
            return ((long)data[0] & 0xFFL) << 32 | ((long)data[1] & 0xFFL) << 24 | ((long)data[2] & 0xFFL) << 16 | ((long)data[3] & 0xFFL) << 8 | (long)data[4] & 0xFFL;
        }
        if (data.length == 4) {
            return ((long)data[0] & 0xFFL) << 24 | ((long)data[1] & 0xFFL) << 16 | ((long)data[2] & 0xFFL) << 8 | (long)data[3] & 0xFFL;
        }
        if (data.length == 3) {
            return ((long)data[0] & 0xFFL) << 16 | ((long)data[1] & 0xFFL) << 8 | (long)data[2] & 0xFFL;
        }
        if (data.length == 2) {
            return ((long)data[0] & 0xFFL) << 8 | (long)data[1] & 0xFFL;
        }
        if (data.length == 1) {
            return data[0];
        }
        throw new IllegalArgumentException("Decoded data has invalid length " + data.length);
    }
}

