/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.binary.codec;

import io.github.mmm.binary.codec.Base;
import io.github.mmm.binary.codec.BaseGeneric;
import io.github.mmm.binary.codec.CoderConfig;
import java.util.Arrays;

abstract class CoderConfigMapped
extends CoderConfig {
    static final int PAD = -2;
    static final int SPACE = -3;
    private static final int[] EMPTY_MAP = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -3, -1, -1, -3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    final char[] chars;
    final int[] map;
    final char padding;
    private final boolean caseSensitive;

    public CoderConfigMapped(String alphabet, char padding) {
        int i;
        this.chars = alphabet.toCharArray();
        this.padding = padding;
        boolean lower = false;
        boolean upper = false;
        this.map = Arrays.copyOf(EMPTY_MAP, EMPTY_MAP.length);
        if (padding != '\u0000') {
            this.map[padding] = -2;
        }
        for (i = 0; i < this.chars.length; i = (int)((byte)(i + 1))) {
            char c = this.chars[i];
            if (c < '\u0014' || c >= '\u007f') {
                Base.illegalCharacter(c, i);
            } else if (c >= 'a' && c <= 'z') {
                lower = true;
            } else if (c >= 'A' && c <= 'Z') {
                upper = true;
            }
            if (this.map[c] != -1) {
                if (this.map[c] >= 0) {
                    BaseGeneric.illegalCharacter("Duplicate", c, i);
                } else {
                    BaseGeneric.illegalCharacter(c, i);
                }
            }
            this.map[c] = i;
        }
        boolean bl = this.caseSensitive = lower && upper;
        if (!this.caseSensitive) {
            i = 0;
            for (char c : this.chars) {
                if (c >= 'a' && c <= 'z') {
                    c = Character.toUpperCase(c);
                } else if (c >= 'A' && c <= 'Z') {
                    c = Character.toLowerCase(c);
                }
                int n = i;
                i = (byte)(i + 1);
                this.map[c] = n;
            }
        }
    }

    @Override
    protected boolean isCaseSensitive() {
        return this.caseSensitive;
    }
}

