/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.binary.codec;

import io.github.mmm.binary.codec.Base;
import io.github.mmm.binary.codec.BaseFormat;
import io.github.mmm.binary.codec.BaseGeneric;
import io.github.mmm.binary.codec.CoderConfigPowerOfTwo;
import io.github.mmm.binary.codec.Decoder;
import java.util.Arrays;

class DecoderPowerOfTwo
extends Decoder {
    private final CoderConfigPowerOfTwo config;

    protected DecoderPowerOfTwo(BaseFormat format, byte[] encodedData, CoderConfigPowerOfTwo config) {
        super(format, encodedData, DecoderPowerOfTwo.capactiy(format, encodedData, config));
        this.config = config;
    }

    private static int capactiy(BaseFormat format, byte[] encodedData, CoderConfigPowerOfTwo config) {
        int capacity;
        int encodedLength;
        int alphabetChars = encodedLength = encodedData.length;
        if (!format.isFailOnWhitespace()) {
            alphabetChars = 0;
            for (byte b : encodedData) {
                int code = -1;
                if (b > 0 && b < 127) {
                    code = config.map[b];
                }
                if (code < 0) continue;
                ++alphabetChars;
            }
        } else if (config.padding != '\u0000') {
            for (int i = encodedLength - 1; i > 0; --i) {
                if (encodedData[i] != config.padding) continue;
                --alphabetChars;
            }
        }
        if ((capacity = alphabetChars * config.bitConfig.bytesPerChunk / config.bitConfig.charsPerChunk) == 0) {
            capacity = encodedLength;
        }
        return capacity;
    }

    @Override
    protected byte[] decode() {
        int outputLength;
        int fullShift;
        int inputLength = this.input.length;
        int[] map = this.config.map;
        int bitCount = this.config.bitConfig.bitCount;
        int charsPerChunk = this.config.bitConfig.charsPerChunk;
        int bytesPerChunk = this.config.bitConfig.bytesPerChunk;
        int shift = fullShift = bitCount * (charsPerChunk - 1);
        boolean failOnWhitespace = this.format.failOnWhitespace;
        int paddingCount = 0;
        long bits = 0L;
        int alphabetChars = inputLength;
        if (!this.format.isFailOnWhitespace()) {
            alphabetChars = 0;
            for (byte b : this.input) {
                int code = -1;
                if (b > 0 && b < 127) {
                    code = this.config.map[b];
                }
                if (code < 0) continue;
                ++alphabetChars;
            }
        } else if (this.config.padding != '\u0000') {
            while (inputLength > 0 && this.input[inputLength - 1] == this.config.padding) {
                --inputLength;
                --alphabetChars;
                ++paddingCount;
            }
        }
        if ((outputLength = alphabetChars * bytesPerChunk / charsPerChunk) == 0 && inputLength > 0) {
            throw new IllegalArgumentException("Invalid input length " + inputLength);
        }
        byte[] output = new byte[outputLength];
        int outputIndex = 0;
        int inputIndex = 0;
        while (inputIndex < inputLength) {
            byte c = this.input[inputIndex++];
            int code = -1;
            if (c > 0 && c < 127) {
                code = map[c];
            }
            if (code == -1) {
                Base.illegalCharacter((char)c, inputIndex - 1);
                continue;
            }
            if (code == -2) {
                ++paddingCount;
                while (inputIndex < inputLength) {
                    byte next;
                    if ((next = this.input[inputIndex++]) != c) {
                        BaseGeneric.illegalCharacter((char)next);
                    }
                    ++paddingCount;
                }
                break;
            }
            if (code == -3) {
                if (!failOnWhitespace) continue;
                Base.illegalCharacter((char)c);
                continue;
            }
            bits |= (long)code << shift;
            if ((shift -= bitCount) >= 0) continue;
            if (bytesPerChunk == 5) {
                output[outputIndex++] = (byte)(bits >> 32);
                output[outputIndex++] = (byte)(bits >> 24);
            }
            if (bytesPerChunk >= 3) {
                output[outputIndex++] = (byte)(bits >> 16);
                output[outputIndex++] = (byte)(bits >> 8);
            }
            output[outputIndex++] = (byte)bits;
            bits = 0L;
            shift = fullShift;
        }
        if (shift != fullShift) {
            int charsInChunk = (fullShift - shift) / bitCount;
            int remain = this.config.bitConfig.getBytes2Decode(charsInChunk);
            if (this.format.isFailOnMissingPadding() && remain + paddingCount != charsPerChunk) {
                throw new IllegalArgumentException("Invalid padding " + paddingCount + " as " + (charsPerChunk - remain) + " was expected!");
            }
            if (bytesPerChunk == 5) {
                output[outputIndex++] = (byte)(bits >> 32);
                if (--remain > 0) {
                    output[outputIndex++] = (byte)(bits >> 24);
                    --remain;
                }
            }
            if (bytesPerChunk >= 3 && remain > 0) {
                output[outputIndex++] = (byte)(bits >> 16);
                if (--remain > 0) {
                    output[outputIndex++] = (byte)(bits >> 8);
                    --remain;
                }
            }
            assert (remain == 0);
        }
        if (outputIndex >= output.length) {
            return output;
        }
        return Arrays.copyOfRange(output, 0, outputIndex);
    }
}

