/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.binary.codec;

import io.github.mmm.binary.codec.BaseFormat;
import io.github.mmm.binary.codec.CoderConfigDivMod;
import io.github.mmm.binary.codec.Encoder;

class EncoderDivMod
extends Encoder {
    private final CoderConfigDivMod config;

    public EncoderDivMod(BaseFormat format, byte[] data, CoderConfigDivMod config) {
        super(format, data);
        this.config = config;
    }

    @Override
    protected String encode() {
        int capacity;
        int leadingZeros;
        for (leadingZeros = 0; leadingZeros < this.input.length && this.input[leadingZeros] == 0; ++leadingZeros) {
        }
        byte[] in = new byte[this.input.length - leadingZeros];
        System.arraycopy(this.input, leadingZeros, in, 0, in.length);
        int inIndex = 0;
        char[] chars = this.config.chars;
        int alphabetLength = chars.length;
        if (alphabetLength == 10) {
            capacity = (int)(2.41 * (double)this.input.length) + 1;
        } else if (alphabetLength == 56) {
            capacity = (int)(1.377 * (double)this.input.length) + 1;
        } else if (alphabetLength == 58) {
            capacity = (int)(1.367 * (double)this.input.length) + 1;
        } else {
            capacity = this.input.length * 2;
            if (alphabetLength < 16) {
                capacity += this.input.length;
            }
        }
        char[] output = new char[capacity];
        int outputStart = output.length;
        while (inIndex < in.length) {
            byte mod = EncoderDivMod.divMod(in, inIndex, alphabetLength);
            if (in[inIndex] == 0) {
                ++inIndex;
            }
            output[--outputStart] = chars[mod];
        }
        char zeroChar = chars[0];
        while (outputStart < output.length && output[outputStart] == zeroChar) {
            ++outputStart;
        }
        for (int i = 0; i < leadingZeros; ++i) {
            output[--outputStart] = zeroChar;
        }
        if (outputStart == 0) {
            return new String(output);
        }
        return new String(output, outputStart, output.length - outputStart);
    }

    private static byte divMod(byte[] number, int offset, int base) {
        int remainder = 0;
        for (int i = offset; i < number.length; ++i) {
            int digit = number[i] & 0xFF;
            int temp = remainder * 256 + digit;
            number[i] = (byte)(temp / base);
            remainder = temp % base;
        }
        return (byte)remainder;
    }
}

