/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.binary.codec;

import io.github.mmm.binary.codec.BaseFormat;
import io.github.mmm.binary.codec.CoderConfigPowerOfTwo;
import io.github.mmm.binary.codec.Encoder;

class EncoderPowerOfTwo
extends Encoder {
    private final CoderConfigPowerOfTwo config;

    protected EncoderPowerOfTwo(BaseFormat format, byte[] data, CoderConfigPowerOfTwo config) {
        super(format, data);
        this.config = config;
    }

    private static int capacity(BaseFormat format, byte[] data, CoderConfigPowerOfTwo config) {
        String newline;
        int dataLength = data.length;
        int mod = dataLength % config.bitConfig.bytesPerChunk;
        int capacity = (dataLength - mod) * config.bitConfig.charsPerChunk / config.bitConfig.bytesPerChunk;
        if (mod > 0) {
            boolean doPadding;
            boolean bl = doPadding = !format.isOmitPadding() || config.padding != '\u0000';
            capacity = doPadding ? (capacity += config.bitConfig.charsPerChunk) : capacity + mod + 1;
        }
        if ((newline = format.newline) != null) {
            int lines = (capacity - 1) / format.charsPerLine;
            capacity += lines * newline.length();
        }
        return capacity;
    }

    @Override
    protected String encode() {
        char[] chars = this.config.chars;
        int mask = this.config.bitConfig.mask;
        int bitCount = this.config.bitConfig.bitCount;
        int charsPerChunk = this.config.bitConfig.charsPerChunk;
        int bytesPerChunk = this.config.bitConfig.bytesPerChunk;
        char padding = this.config.padding;
        boolean omitPadding = this.format.isOmitPadding() || padding == '\u0000';
        int charsPerLine = this.format.charsPerLine;
        String newline = this.format.newline;
        int newlineLength = 0;
        char newline1 = '\u0000';
        char newline2 = '\u0000';
        if (newline != null) {
            newlineLength = newline.length();
            newline1 = newline.charAt(0);
            if (newlineLength > 1) {
                newline2 = newline.charAt(1);
            }
        }
        int paddingModulo = this.input.length % bytesPerChunk;
        int maxInputIndex = this.input.length - paddingModulo;
        int chunkOffset = charsPerChunk - 1;
        int currentCharLineCount = -charsPerChunk;
        char[] output = new char[EncoderPowerOfTwo.capacity(this.format, this.input, this.config)];
        int outputIndex = 0;
        int inputIndex = 0;
        while (inputIndex < this.input.length) {
            if (newline != null && (currentCharLineCount += charsPerChunk) >= charsPerLine) {
                output[outputIndex++] = newline1;
                if (newlineLength > 1) {
                    output[outputIndex++] = newline2;
                    for (int i = 2; i < newlineLength; ++i) {
                        output[outputIndex++] = newline.charAt(i);
                    }
                }
                currentCharLineCount = 0;
            }
            long bits = 0L;
            switch (bytesPerChunk) {
                case 1: {
                    bits = (long)this.input[inputIndex++] & 0xFFL;
                    break;
                }
                case 3: {
                    if (inputIndex == maxInputIndex) {
                        bits = (long)this.input[inputIndex++] & 0xFFL;
                        if (inputIndex < this.input.length) {
                            bits = bits << 8 | (long)this.input[inputIndex++] & 0xFFL;
                        }
                        bits <<= this.config.bitConfig.getShift4Encode(paddingModulo);
                        chunkOffset = this.config.bitConfig.getChunkChars4Encode(paddingModulo) - 1;
                        break;
                    }
                    bits = (this.input[inputIndex++] & 0xFF) << 16 | (this.input[inputIndex++] & 0xFF) << 8 | this.input[inputIndex++] & 0xFF;
                    break;
                }
                case 5: {
                    if (inputIndex == maxInputIndex) {
                        bits = (long)this.input[inputIndex++] & 0xFFL;
                        while (inputIndex < this.input.length) {
                            bits = bits << 8 | (long)this.input[inputIndex++] & 0xFFL;
                        }
                        bits <<= this.config.bitConfig.getShift4Encode(paddingModulo);
                        chunkOffset = this.config.bitConfig.getChunkChars4Encode(paddingModulo) - 1;
                        break;
                    }
                    bits = ((long)this.input[inputIndex++] & 0xFFL) << 32 | ((long)this.input[inputIndex++] & 0xFFL) << 24 | ((long)this.input[inputIndex++] & 0xFFL) << 16 | ((long)this.input[inputIndex++] & 0xFFL) << 8 | (long)this.input[inputIndex++] & 0xFFL;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            for (int offset = chunkOffset; offset >= 0; --offset) {
                int index = (int)bits & mask;
                output[outputIndex + offset] = chars[index];
                bits >>>= bitCount;
            }
            outputIndex = outputIndex + chunkOffset + 1;
        }
        if (paddingModulo > 0 && !omitPadding) {
            for (int i = charsPerChunk - chunkOffset - 1; i > 0; --i) {
                output[outputIndex++] = padding;
            }
        }
        if (outputIndex == output.length) {
            return new String(output);
        }
        return new String(output, 0, outputIndex);
    }
}

