/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.entity.bean.typemapping;

import io.github.mmm.entity.bean.typemapping.SingleTypeMapping;
import io.github.mmm.entity.bean.typemapping.SingleTypeMappingStatic;
import io.github.mmm.entity.bean.typemapping.TypeMapping;
import io.github.mmm.property.ReadableProperty;
import io.github.mmm.value.converter.TypeMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComposedTypeMapping
implements TypeMapping {
    private static final Logger LOG = LoggerFactory.getLogger(ComposedTypeMapping.class);
    private Map<Class<?>, SingleTypeMapping<?>> typeMap = new HashMap();
    private final Map<Class<?>, Class<?>> classMap = new ConcurrentHashMap();

    private void remap(Class<?> source, Class<?> target) {
        assert (source != target);
        Objects.requireNonNull(source);
        Objects.requireNonNull(target);
        Class<?> duplicate = this.classMap.put(source, target);
        if (duplicate != null && duplicate != target) {
            LOG.warn("Overriding mapping of " + source.getName() + " to " + duplicate.getName() + " with " + target.getName());
        }
    }

    protected void add(SingleTypeMapping<?> singleMapper) {
        SingleTypeMapping<?> duplicate = this.typeMap.put(singleMapper.getTypeMapper().getSourceType(), singleMapper);
        if (duplicate != null) {
            LOG.warn("Overriding " + String.valueOf(duplicate) + " with " + String.valueOf(singleMapper));
        }
    }

    protected void add(Class<?> type, String declaration) {
        this.add(new SingleTypeMappingStatic(type, declaration));
    }

    protected void add(TypeMapper<?, ?> typeMapper) {
        if (typeMapper == null) {
            return;
        }
        this.add(new SingleTypeMappingStatic(typeMapper));
    }

    @Override
    public <V> TypeMapper<V, ?> getTypeMapper(Class<V> valueType, ReadableProperty<?> property) {
        SingleTypeMapping<V> singleMapping = this.getSingleMapping(valueType);
        if (singleMapping == null) {
            return null;
        }
        return singleMapping.getTypeMapper(property);
    }

    private <V> SingleTypeMapping<V> getSingleMapping(Class<V> valueType) {
        SingleTypeMapping<?> singleMapping = this.typeMap.get(valueType);
        if (singleMapping == null) {
            Class<Object> remappedClass = this.classMap.get(valueType);
            if (remappedClass == null) {
                remappedClass = Object.class;
                for (Class<V> clazz : this.typeMap.keySet()) {
                    if (!clazz.isAssignableFrom(valueType)) continue;
                    remappedClass = clazz;
                    break;
                }
                this.remap(valueType, remappedClass);
            }
            if (remappedClass == Object.class) {
                return null;
            }
            singleMapping = this.typeMap.get(remappedClass);
        }
        return singleMapping;
    }

    public void secure() {
        this.typeMap = Collections.unmodifiableMap(this.typeMap);
    }
}

