/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.entity.property.id;

import io.github.mmm.entity.id.GenericId;
import io.github.mmm.entity.id.Id;
import io.github.mmm.entity.id.RevisionedIdVersion;
import io.github.mmm.marshall.StructuredReader;
import io.github.mmm.marshall.StructuredWriter;
import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.object.SimpleProperty;

public abstract class IdProperty<V extends Id<?>>
extends SimpleProperty<V> {
    private V value;
    private Class<?> entityClass;

    public IdProperty(String name, V id, PropertyMetadata<V> metadata) {
        super(name, metadata);
        if (id == null) {
            this.value = RevisionedIdVersion.DEFAULT;
        } else {
            this.doSet(id);
        }
    }

    protected V doGet() {
        return this.value;
    }

    protected void doSet(V newValue) {
        if (newValue != null) {
            Class newEntityClass = newValue.getEntityClass();
            if (this.entityClass == null) {
                this.entityClass = newEntityClass;
            } else if (newEntityClass == null) {
                newValue = ((GenericId)newValue).withEntityTypeGeneric(this.entityClass);
            } else if (!this.entityClass.isAssignableFrom(newEntityClass)) {
                throw new IllegalArgumentException("Cannot set ID of type " + newEntityClass.getName() + " to " + ((Object)((Object)this)).getClass().getSimpleName() + " " + this.getName() + " with incompatible type " + this.entityClass.getName());
            }
        }
        this.value = newValue;
    }

    public V getFallbackSafeValue() {
        return (V)RevisionedIdVersion.DEFAULT;
    }

    public Class<V> getValueClass() {
        return Id.class;
    }

    public V parse(String valueAsString) {
        return (V)((GenericId)this.value).create(valueAsString);
    }

    protected V readValue(StructuredReader reader, boolean apply) {
        GenericId id = ((GenericId)this.value).readObject(reader);
        if (apply) {
            this.set(id);
        }
        return (V)id;
    }

    public void writeValue(StructuredWriter writer, V id) {
        ((GenericId)id).write(writer);
    }
}

