/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.entity.property.link;

import io.github.mmm.bean.WritableBean;
import io.github.mmm.entity.bean.EntityBean;
import io.github.mmm.entity.id.Id;
import io.github.mmm.entity.id.IdMarshalling;
import io.github.mmm.entity.link.AbstractLink;
import io.github.mmm.entity.link.IdLink;
import io.github.mmm.entity.link.Link;
import io.github.mmm.entity.link.LinkMapper;
import io.github.mmm.entity.property.id.IdProperty;
import io.github.mmm.marshall.StructuredReader;
import io.github.mmm.marshall.StructuredWriter;
import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.ReadableProperty;
import io.github.mmm.property.criteria.CriteriaPredicate;
import io.github.mmm.property.criteria.PredicateOperator;
import io.github.mmm.property.object.ObjectProperty;
import io.github.mmm.value.PropertyPath;
import io.github.mmm.value.ReadableValue;
import io.github.mmm.value.converter.TypeMapper;
import java.util.function.Function;
import java.util.function.Supplier;

public class LinkProperty<E extends EntityBean>
extends ObjectProperty<Link<E>> {
    private Class<E> entityClass;
    private Function<Id<E>, E> resolver;
    private LinkMapper typeMapper;

    public LinkProperty(String name, Class<E> entityClass, PropertyMetadata<Link<E>> metadata) {
        this(name, entityClass, metadata, null);
    }

    public LinkProperty(String name, Class<E> entityClass, PropertyMetadata<Link<E>> metadata, Function<Id<E>, E> resolver) {
        super(name, Link.class, metadata);
        this.entityClass = entityClass;
        this.resolver = resolver;
    }

    public LinkProperty(String name, Link<E> value, PropertyMetadata<Link<E>> metadata) {
        this(name, value, metadata, null);
    }

    public LinkProperty(String name, Link<E> value, PropertyMetadata<Link<E>> metadata, Function<Id<E>, E> resolver) {
        super(name, value, metadata);
        this.entityClass = value.getId().getEntityClass();
        this.resolver = resolver;
    }

    protected void doSet(Link<E> newValue) {
        Id id;
        if (newValue != null && (id = newValue.getId()) != null) {
            if (this.entityClass == null) {
                this.entityClass = id.getEntityClass();
            } else {
                Class idEntityType = id.getEntityClass();
                if (idEntityType == null) {
                    if (newValue instanceof IdLink) {
                        newValue = ((IdLink)newValue).withType(this.entityClass);
                    }
                } else if (!this.entityClass.isAssignableFrom(idEntityType)) {
                    throw new IllegalArgumentException("Cannot set link of type " + idEntityType.getName() + " to property " + this.getName() + " with incompatible entity type " + this.entityClass.getName());
                }
            }
        }
        super.doSet(newValue);
    }

    public E getEntity() {
        Link link = (Link)this.get();
        if (link == null) {
            return null;
        }
        return (E)((EntityBean)link.getTarget());
    }

    public void setEntity(E entity) {
        Link link = Link.of(entity);
        this.set(link);
    }

    public Class<E> getEntityClass() {
        Link link;
        if (this.entityClass == null && (link = (Link)this.get()) != null) {
            Id id = link.getId();
            if (id != null) {
                this.entityClass = id.getEntityClass();
            } else if (link.isResolved()) {
                EntityBean target = (EntityBean)link.getTarget();
                this.entityClass = target.getType().getJavaClass();
            }
        }
        return this.entityClass;
    }

    public TypeMapper<Link<E>, Id<E>> getTypeMapper() {
        if (this.typeMapper == null) {
            this.typeMapper = new LinkMapper(this.resolver);
        }
        return this.typeMapper;
    }

    public boolean isValueMutable() {
        return true;
    }

    protected Supplier<? extends Link<E>> createReadOnlyExpression() {
        ReadOnlyLink readOnlyLink = new ReadOnlyLink();
        return () -> {
            Link link = (Link)this.get();
            if (link == null) {
                return null;
            }
            return readOnlyLink;
        };
    }

    protected Link<E> readValue(StructuredReader reader, boolean apply) {
        Id id = IdMarshalling.get().readObject(reader, this.entityClass);
        IdLink link = IdLink.of((Id)id, this.resolver);
        if (apply) {
            this.setValue(link);
        }
        return link;
    }

    public void writeValue(StructuredWriter writer, Link<E> link) {
        Id id = null;
        if (link != null) {
            id = link.getId();
        }
        IdMarshalling.get().writeObject(writer, id);
    }

    public CriteriaPredicate eq(Id<E> other) {
        return this.eq(Link.of(other));
    }

    public CriteriaPredicate eq(IdProperty other) {
        return this.predicate((ReadableProperty)this, PredicateOperator.EQ, (PropertyPath)other);
    }

    public CriteriaPredicate eq(E other) {
        if (other != null && other.getId() == null) {
            return this.eq(other.Id());
        }
        return this.eq(Link.of(other));
    }

    public CriteriaPredicate neq(Id<E> other) {
        return this.neq(Link.of(other));
    }

    public CriteriaPredicate neq(E other) {
        if (other != null && other.getId() == null) {
            return this.neq(other.Id());
        }
        return this.neq(Link.of(other));
    }

    public CriteriaPredicate neq(IdProperty other) {
        return this.predicate((ReadableProperty)this, PredicateOperator.NEQ, (PropertyPath)other);
    }

    private <V> CriteriaPredicate predicate(ReadableProperty<V> property1, PredicateOperator op, PropertyPath<V> property2) {
        return CriteriaPredicate.of(property1, (PredicateOperator)op, property2);
    }

    public void setResolver(Function<Id<E>, E> resolver) {
        this.resolver = resolver;
        this.typeMapper = null;
        Link link = (Link)this.doGet();
        if (link != null && !link.isResolved() && link instanceof IdLink) {
            IdLink idLink = (IdLink)link;
            idLink.setResolver(resolver);
        }
    }

    public void copyValue(ReadableValue<Link<E>> other) {
        Link link = (Link)other.get();
        if (link != null) {
            link = Link.of((Id)link.getId());
        }
        this.set(link);
    }

    private class ReadOnlyLink
    extends AbstractLink<E> {
        private ReadOnlyLink() {
        }

        public Id<E> getId() {
            return ((Link)LinkProperty.this.get()).getId();
        }

        public E getTarget() {
            EntityBean target = (EntityBean)((Link)LinkProperty.this.get()).getTarget();
            if (target != null) {
                target = (EntityBean)WritableBean.getReadOnly((WritableBean)target);
            }
            return target;
        }

        public boolean isResolved() {
            return ((Link)LinkProperty.this.get()).isResolved();
        }
    }
}

