/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.entity.id;

import io.github.mmm.base.temporal.InstantParser;
import io.github.mmm.base.uuid.UuidParser;
import io.github.mmm.entity.id.AbstractId;
import io.github.mmm.entity.id.GenericId;
import io.github.mmm.entity.id.Id;
import io.github.mmm.entity.id.IdFactory;
import io.github.mmm.entity.id.PkId;
import io.github.mmm.entity.id.PkIdLong;
import io.github.mmm.entity.id.PkIdString;
import io.github.mmm.entity.id.PkIdUuid;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

final class GenericIdFactory
implements IdFactory<Object, Comparable<?>> {
    private static final Map<Class<? extends Id>, GenericId> EMPTY_ID_MAP = new HashMap<Class<? extends Id>, GenericId>();
    static final GenericIdFactory INSTANCE;

    private GenericIdFactory() {
    }

    @Override
    public <E> GenericId<E, Object, Comparable<?>, ?> create(Class<E> entityClass, Object pk, Comparable<?> revision) {
        PkId<E, ?, ?> pkId;
        if (revision instanceof Integer) {
            Integer i = (Integer)((Object)revision);
            revision = i.longValue();
        }
        if ((pkId = PkId.of(entityClass, pk)) == null) {
            assert (revision == null);
            return null;
        }
        return pkId.withRevisionGeneric(revision);
    }

    @Override
    public Object parsePk(String pkString) {
        UUID uuid = UuidParser.get().parse(pkString);
        if (uuid != null) {
            return uuid;
        }
        return pkString;
    }

    @Override
    public Comparable<?> parseRevision(String revisionString) {
        Instant instant = InstantParser.get().parse(revisionString);
        if (instant != null) {
            return instant;
        }
        return Long.valueOf(revisionString);
    }

    static <E, I extends Id> GenericId<E, ?, ?, ?> empty(Class<E> entityType, Class<I> idClass) {
        GenericId empty = EMPTY_ID_MAP.get(idClass);
        if (empty == null) {
            throw new IllegalStateException(idClass.getName());
        }
        return empty.withEntityType((Class)entityType);
    }

    static {
        EMPTY_ID_MAP.put(null, PkIdLong.getEmpty());
        EMPTY_ID_MAP.put(Id.class, PkIdLong.getEmpty());
        EMPTY_ID_MAP.put(GenericId.class, PkIdLong.getEmpty());
        EMPTY_ID_MAP.put(AbstractId.class, PkIdLong.getEmpty());
        EMPTY_ID_MAP.put(PkIdLong.class, PkIdLong.getEmpty());
        EMPTY_ID_MAP.put(PkId.class, PkIdLong.getEmpty());
        EMPTY_ID_MAP.put(PkIdLong.class, PkIdLong.getEmpty());
        EMPTY_ID_MAP.put(PkIdString.class, PkIdString.getEmpty());
        EMPTY_ID_MAP.put(PkIdUuid.class, PkIdUuid.getEmpty());
        INSTANCE = new GenericIdFactory();
    }
}

