/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.entity.id;

import io.github.mmm.entity.Entity;
import io.github.mmm.entity.id.PkId;
import java.util.function.Supplier;

public interface Id<E>
extends Supplier<Object> {
    public static final String PROPERTY_PK = "pk";
    public static final String PROPERTY_REVISION = "rev";
    public static final String COLUMN_REVISION = "Rev";
    public static final Comparable<?> REVISION_LATEST = null;
    public static final char REVISION_SEPARATOR = '@';

    public Object getPk();

    @Override
    default public Object get() {
        return this.getPk();
    }

    default public String getAsString() {
        Object id = this.getPk();
        if (id == null) {
            return null;
        }
        return id.toString();
    }

    public Class<?> getPkClass();

    default public boolean isEmpty() {
        return this.getPk() == null && this.getRevision() == null;
    }

    public Class<E> getEntityClass();

    public Id<E> withoutRevision();

    public Comparable<?> getRevision();

    public Class<? extends Comparable<?>> getRevisionType();

    default public String getRevisionAsString() {
        Comparable<?> revision = this.getRevision();
        if (revision == null) {
            return null;
        }
        return revision.toString();
    }

    public Id<E> withEntityType(Class<E> var1);

    public <T> Id<T> withEntityTypeGeneric(Class<T> var1);

    default public boolean isTransient() {
        return this.getRevision() == null;
    }

    public String toString();

    public static <E extends Entity> Id<E> from(E entity) {
        if (entity == null) {
            return null;
        }
        Id<?> id = entity.getId();
        if (id.getEntityClass() == null) {
            id = id.withEntityTypeGeneric(entity.getJavaClass());
        }
        return id;
    }

    public static <E> Id<E> of(Class<E> type, Object pk) {
        return PkId.of(type, pk);
    }
}

