/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.entity.id;

import io.github.mmm.entity.id.GenericId;
import io.github.mmm.entity.id.GenericIdFactory;
import io.github.mmm.entity.id.Id;

public interface IdFactory<P, R extends Comparable<?>> {
    public <E> GenericId<E, P, R, ?> create(Class<E> var1, P var2, R var3);

    default public <E> GenericId<E, P, R, ?> create(Class<E> entityType, String pkString) {
        String id = null;
        String revision = null;
        if (pkString != null && !pkString.isEmpty()) {
            int i = pkString.indexOf(64);
            if (i > 0) {
                id = pkString.substring(0, i);
                revision = pkString.substring(i + 1);
            } else {
                id = pkString;
            }
        }
        return this.createGeneric(entityType, id, revision);
    }

    default public <E> GenericId<E, P, R, ?> createGeneric(Class<E> entityType, Object pk, Object revision) {
        if (pk instanceof String) {
            pk = this.parsePk((String)pk);
        }
        if (revision instanceof String) {
            revision = this.parseRevision((String)revision);
        }
        return this.create(entityType, pk, (Comparable)revision);
    }

    public P parsePk(String var1);

    public R parseRevision(String var1);

    default public <E, ID extends Id> GenericId<E, ?, ?, ?> createEmpty(Class<E> entityType, Class<ID> pkClass) {
        return GenericIdFactory.empty(entityType, pkClass);
    }

    public static IdFactory<Object, Comparable<?>> get() {
        return GenericIdFactory.INSTANCE;
    }
}

