/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.entity.id;

import io.github.mmm.base.exception.DuplicateObjectException;
import io.github.mmm.base.uuid.UuidParser;
import io.github.mmm.entity.id.GenericId;
import io.github.mmm.entity.id.Id;
import io.github.mmm.entity.id.IdFactory;
import io.github.mmm.entity.id.IdMarshallingImpl;
import io.github.mmm.entity.id.RevisionedIdVersion;
import io.github.mmm.marshall.Marshalling;
import io.github.mmm.marshall.StructuredReader;
import io.github.mmm.marshall.StructuredWriter;

public interface IdMarshalling
extends Marshalling<Id<?>> {
    default public void writeObject(StructuredWriter writer, Id<?> id) {
        if (id == null) {
            writer.writeValueAsNull();
            return;
        }
        ((GenericId)id).write(writer);
    }

    default public Id<?> readObject(StructuredReader reader) {
        return this.readObject(reader, null);
    }

    default public <E> Id<E> readObject(StructuredReader reader, Class<E> type) {
        return IdMarshalling.readObject(reader, IdFactory.get(), type);
    }

    public static <E, I, V extends Comparable<?>> GenericId<E, I, V, ?> readObject(StructuredReader reader, IdFactory<I, V> factory, Class<E> entityType) {
        Object pk = null;
        Object revision = null;
        try {
            if (reader.readStartObject(RevisionedIdVersion.DEFAULT)) {
                while (!reader.readEnd()) {
                    String name = reader.readName();
                    if ("l".equals(name)) {
                        pk = IdMarshalling.update(pk, reader.readValueAsLong(), "pk");
                        continue;
                    }
                    if ("u".equals(name)) {
                        pk = IdMarshalling.update(pk, UuidParser.get().parse(reader.readValueAsString()), "pk");
                        continue;
                    }
                    if ("s".equals(name)) {
                        pk = IdMarshalling.update(pk, reader.readValueAsString(), "pk");
                        continue;
                    }
                    if ("v".equals(name)) {
                        revision = IdMarshalling.update(revision, reader.readValueAsLong(), "rev");
                        continue;
                    }
                    if (!"t".equals(name)) continue;
                    revision = IdMarshalling.update(revision, reader.readValueAsInstant(), "rev");
                }
            } else {
                pk = reader.isStringValue() ? reader.readValueAsString() : reader.readValueAsLong();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse Id.", e);
        }
        return factory.createGeneric(entityType, pk, revision);
    }

    private static Object update(Object oldValue, Object newValue, String key) {
        if (oldValue == null) {
            return newValue;
        }
        if (newValue == null) {
            return oldValue;
        }
        throw new DuplicateObjectException(newValue, (Object)key, oldValue);
    }

    public static IdMarshalling get() {
        return IdMarshallingImpl.INSTANCE;
    }
}

