/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.entity.id;

import io.github.mmm.entity.id.AbstractId;
import io.github.mmm.entity.id.GenericId;
import io.github.mmm.entity.id.PkIdLong;
import io.github.mmm.entity.id.PkIdString;
import io.github.mmm.entity.id.PkIdUuid;
import io.github.mmm.entity.id.RevisionedIdInstant;
import io.github.mmm.entity.id.RevisionedIdVersion;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;

public abstract class PkId<E, P, SELF extends PkId<E, P, SELF>>
extends AbstractId<E, P, Comparable<?>, SELF> {
    protected final Class<E> entityClass;

    protected PkId(Class<E> entityClass) {
        this.entityClass = entityClass;
    }

    @Override
    public final Class<E> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public Comparable<?> getRevision() {
        return null;
    }

    @Override
    public boolean hasRevisionField() {
        return false;
    }

    @Override
    public Class<Comparable<?>> getRevisionType() {
        return Comparable.class;
    }

    @Override
    public Comparable<?> parseRevision(String revisionString) {
        return null;
    }

    @Override
    public Comparable<?> updateRevision(Comparable<?> currentRevision) {
        return null;
    }

    @Override
    public String getMarshalPropertyRevision() {
        return null;
    }

    protected abstract SELF newId(Class<E> var1, P var2);

    @Override
    public <T> GenericId<T, P, Comparable<?>, ?> create(Class<T> entityType, P pk, Comparable<?> revision) {
        SELF id = this.newId(entityType, pk);
        return ((PkId)id).withRevisionGeneric(revision);
    }

    public SELF withoutRevision() {
        return (SELF)((PkId)this.self());
    }

    public <T> PkId<T, P, ?> withEntityTypeGeneric(Class<T> newEntityClass) {
        return this.withEntityType(newEntityClass);
    }

    @Override
    public SELF withEntityType(Class<E> newEntityClass) {
        if (this.entityClass == newEntityClass) {
            return (SELF)((PkId)this.self());
        }
        if (this.entityClass == null) {
            return this.newId(newEntityClass, this.getPk());
        }
        throw new IllegalArgumentException("Illegal type " + newEntityClass.getName() + " - already typed to " + this.entityClass.getName() + " at " + this.toString());
    }

    @Override
    public SELF withPk(P newPk) {
        if (Objects.equals(this.getPk(), newPk)) {
            return (SELF)((PkId)this.self());
        }
        return this.newId(this.getEntityClass(), newPk);
    }

    @Override
    public SELF withPkAndRevision(P newPk, Comparable<?> newRevision) {
        if (newRevision != null) {
            throw new IllegalArgumentException("Cannot change revision type to " + newRevision.getClass().getName() + " - use withRevisionGeneric instead!");
        }
        if (Objects.equals(this.getPk(), newPk)) {
            return (SELF)((PkId)this.self());
        }
        return this.newId(this.getEntityClass(), newPk);
    }

    @Override
    @Deprecated
    public SELF withRevision(Comparable<?> newRevision) {
        if (newRevision != null) {
            throw new IllegalArgumentException("You must use withRevisionGeneric instead to avoid violating generic contract.");
        }
        return (SELF)((PkId)this.self());
    }

    public <R extends Comparable<?>> GenericId<E, P, R, ?> withRevisionGeneric(R newRevision) {
        AbstractId result;
        if (newRevision == null) {
            result = this;
        } else if (newRevision instanceof Long) {
            Long rev = (Long)newRevision;
            result = new RevisionedIdVersion(this, rev);
        } else if (newRevision instanceof Instant) {
            Instant rev = (Instant)newRevision;
            result = new RevisionedIdInstant(this, rev);
        } else if (newRevision instanceof Integer) {
            Integer rev = (Integer)newRevision;
            result = new RevisionedIdVersion(this, rev.longValue());
        } else {
            throw new IllegalArgumentException("Unsupported revision type " + newRevision.getClass().getName() + "!");
        }
        return result;
    }

    public static <E> PkId<E, ?, ?> of(Class<E> type, Object pk) {
        if (pk == null) {
            return null;
        }
        if (pk instanceof Long) {
            Long l = (Long)pk;
            return new PkIdLong<E>(type, l);
        }
        if (pk instanceof UUID) {
            UUID u = (UUID)pk;
            return new PkIdUuid<E>(type, u);
        }
        if (pk instanceof String) {
            String s = (String)pk;
            return new PkIdString<E>(type, s);
        }
        if (pk instanceof Integer) {
            Integer i = (Integer)pk;
            return new PkIdLong<E>(type, i.longValue());
        }
        throw new IllegalArgumentException("Unsupported primary key type " + pk.getClass().getName());
    }
}

