/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.entity.id;

import io.github.mmm.entity.id.PkId;

public final class PkIdLong<E>
extends PkId<E, Long, PkIdLong<E>> {
    private static final PkIdLong EMPTY = new PkIdLong(null, null);
    private final Long pk;

    public PkIdLong(Class<E> type, Long pk) {
        super(type);
        this.pk = pk;
    }

    @Override
    public Long getPk() {
        return this.pk;
    }

    @Override
    protected PkIdLong<E> newId(Class<E> newEntityClass, Long newPk) {
        return new PkIdLong<E>(newEntityClass, newPk);
    }

    @Override
    public Class<Long> getPkClass() {
        return Long.class;
    }

    public long getPkAsLong() {
        Long id = this.getPk();
        if (id == null) {
            return -1L;
        }
        return id;
    }

    @Override
    public Long parsePk(String idString) {
        return Long.valueOf(idString);
    }

    @Override
    public String getMarshalPropertyId() {
        return "l";
    }

    public static <E> PkIdLong<E> getEmpty() {
        return EMPTY;
    }

    public static <E> PkIdLong<E> getEmpty(Class<E> entityType) {
        PkIdLong<E> empty = PkIdLong.getEmpty();
        return (PkIdLong)empty.withEntityType((Class)entityType);
    }

    static <E> PkIdLong<E> of(Long pk) {
        return PkIdLong.of(pk, null);
    }

    public static <E> PkIdLong<E> of(Long pk, Class<E> entityClass) {
        if (pk == null) {
            return null;
        }
        return new PkIdLong<E>(entityClass, pk);
    }
}

