/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.entity.id;

import io.github.mmm.base.uuid.UuidParser;
import io.github.mmm.entity.id.PkId;
import java.util.UUID;

public final class PkIdUuid<E>
extends PkId<E, UUID, PkIdUuid<E>> {
    private static final PkIdUuid EMPTY = new PkIdUuid(null, null);
    private final UUID pk;

    public PkIdUuid(Class<E> entityClass, UUID pk) {
        super(entityClass);
        this.pk = pk;
    }

    @Override
    public UUID getPk() {
        return this.pk;
    }

    @Override
    protected PkIdUuid<E> newId(Class<E> newEntityClass, UUID newPk) {
        return new PkIdUuid<E>(newEntityClass, newPk);
    }

    @Override
    public Class<UUID> getPkClass() {
        return UUID.class;
    }

    @Override
    public UUID parsePk(String idString) {
        if (idString == null) {
            return null;
        }
        UUID uuid = UuidParser.get().parse(idString);
        if (uuid == null) {
            throw new IllegalArgumentException(idString);
        }
        return uuid;
    }

    @Override
    public String getMarshalPropertyId() {
        return "u";
    }

    public static <E> PkIdUuid<E> getEmpty() {
        return EMPTY;
    }

    public static <E> PkIdUuid<E> getEmpty(Class<E> entityType) {
        PkIdUuid<E> empty = PkIdUuid.getEmpty();
        return (PkIdUuid)empty.withEntityType((Class)entityType);
    }

    public static <E> PkIdUuid<E> of(UUID pk) {
        return PkIdUuid.of(pk, null);
    }

    public static <E> PkIdUuid<E> of(UUID pk, Class<E> type) {
        if (pk == null) {
            return null;
        }
        return new PkIdUuid<E>(type, pk);
    }
}

