/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.entity.id;

import io.github.mmm.base.lang.Builder;
import io.github.mmm.entity.id.GenericId;
import io.github.mmm.entity.id.Id;
import io.github.mmm.value.converter.CompositeTypeMapper;
import io.github.mmm.value.converter.TypeMapper;
import java.util.Objects;

public abstract class PkMapper
extends CompositeTypeMapper<Id, Object> {
    protected final GenericId idTemplate;

    PkMapper(GenericId idTemplate, String suffix, PkMapper next) {
        super(suffix, (CompositeTypeMapper)next);
        this.idTemplate = idTemplate == null ? next.idTemplate : idTemplate;
    }

    public Class<? extends Id> getSourceType() {
        return this.idTemplate.getClass();
    }

    public TypeMapper.NameMode getNameMode() {
        return TypeMapper.NameMode.SUFFIX;
    }

    public Builder<Id> sourceBuilder() {
        return new IdBuilder(this.idTemplate);
    }

    public static PkMapper of(Id<?> id) {
        Objects.requireNonNull(id);
        GenericId genericId = (GenericId)id;
        PkMapperRevision revMapper = null;
        if (genericId.hasRevisionField()) {
            revMapper = new PkMapperRevision((GenericId)genericId.withPkAndRevision(null, null));
        }
        return new PkMapperId(genericId, revMapper);
    }

    private static class IdBuilder
    implements Builder<Id> {
        private GenericId id;

        private IdBuilder(GenericId id) {
            this.id = id;
        }

        private void withId(Object newId) {
            this.id = this.id.withPk(newId);
        }

        private void withRevision(Object newRevision) {
            this.id = this.id.withRevision((Comparable)newRevision);
        }

        public GenericId build() {
            return this.id;
        }
    }

    private static class PkMapperRevision
    extends PkMapper {
        private PkMapperRevision(GenericId idTemplate) {
            super(idTemplate, "Rev", null);
        }

        public Class<? extends Object> getTargetType() {
            return this.idTemplate.getRevisionType();
        }

        public Object toTarget(Id id) {
            return id.getRevision();
        }

        public void with(Builder<Id> builder, Object revision) {
            IdBuilder idBuilder = (IdBuilder)builder;
            idBuilder.withRevision(revision);
        }
    }

    private static class PkMapperId
    extends PkMapper {
        public PkMapperId(PkMapperRevision next) {
            super(null, "Id", next);
        }

        public PkMapperId(GenericId idTemplate, PkMapperRevision next) {
            super(idTemplate, "Id", next);
        }

        public Class<? extends Object> getTargetType() {
            return this.idTemplate.getPkClass();
        }

        @Override
        public TypeMapper.NameMode getNameMode() {
            return TypeMapper.NameMode.NAME;
        }

        public Id toSource(Object target) {
            assert (this.next() == null);
            assert (!this.idTemplate.hasRevisionField());
            return this.idTemplate.withPkAndRevision(target, null);
        }

        public Object toTarget(Id id) {
            return id.getPk();
        }

        public void with(Builder<Id> builder, Object id) {
            IdBuilder idBuilder = (IdBuilder)builder;
            idBuilder.withId(id);
        }
    }
}

