/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.entity.id;

import io.github.mmm.entity.id.AbstractId;
import io.github.mmm.entity.id.GenericId;
import io.github.mmm.entity.id.PkId;
import java.util.Objects;

public abstract class RevisionedId<E, P, R extends Comparable<?>, SELF extends RevisionedId<E, P, R, SELF>>
extends AbstractId<E, P, R, SELF> {
    protected final PkId<E, P, ?> id;

    protected RevisionedId(PkId<E, P, ?> id) {
        this.id = id;
    }

    @Override
    public final boolean hasRevisionField() {
        return true;
    }

    @Override
    public final P getPk() {
        return this.id.getPk();
    }

    @Override
    public final Class<P> getPkClass() {
        return this.id.getPkClass();
    }

    @Override
    public P parsePk(String idString) {
        return this.id.parsePk(idString);
    }

    @Override
    public final Class<E> getEntityClass() {
        return this.id.getEntityClass();
    }

    @Override
    public final String getMarshalPropertyId() {
        return this.id.getMarshalPropertyId();
    }

    @Override
    public <T> GenericId<T, P, R, ?> create(Class<T> entityType, P pk, R revision) {
        GenericId newId = ((PkId)this.id.withEntityTypeGeneric((Class)entityType)).withPk((Object)pk);
        return this.newId((PkId<E, P, ?>)newId, revision);
    }

    protected abstract SELF newId(PkId<E, P, ?> var1, R var2);

    @Override
    public SELF withPk(P newPk) {
        GenericId newId = this.id.withPk((Object)newPk);
        if (newId == this.id) {
            return (SELF)((RevisionedId)this.self());
        }
        return this.newId((PkId<E, P, ?>)newId, this.getRevision());
    }

    @Override
    public SELF withPkAndRevision(P newPk, R newRevision) {
        GenericId newId = this.id.withPk((Object)newPk);
        if (newId == this.id && Objects.equals(this.getRevision(), newRevision)) {
            return (SELF)((RevisionedId)this.self());
        }
        return this.newId((PkId<E, P, ?>)newId, newRevision);
    }

    @Override
    public SELF withRevision(R newRevision) {
        if (Objects.equals(this.getRevision(), newRevision)) {
            return (SELF)((RevisionedId)this.self());
        }
        return this.newId(this.id, newRevision);
    }

    @Override
    public <T> RevisionedId<T, P, R, ?> withEntityTypeGeneric(Class<T> newEntityType) {
        return this.withEntityType(newEntityType);
    }

    @Override
    public SELF withEntityType(Class<E> newEntityType) {
        GenericId newId = this.id.withEntityType((Class)newEntityType);
        if (newId == this.id) {
            return (SELF)((RevisionedId)this.self());
        }
        return this.newId((PkId<E, P, ?>)newId, this.getRevision());
    }

    @Override
    public SELF updateRevision() {
        Object newRevision = this.updateRevision(this.getRevision());
        return (SELF)this.withRevision((Comparable)newRevision);
    }

    @Override
    public final PkId<E, P, ?> withoutRevision() {
        return this.id;
    }
}

