/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.entity.link;

import io.github.mmm.entity.Entity;
import io.github.mmm.entity.id.GenericId;
import io.github.mmm.entity.id.Id;
import io.github.mmm.entity.link.AbstractLink;
import java.util.function.Function;

public abstract class AbstractIdLink<E>
extends AbstractLink<E> {
    private GenericId<E, ?, ?, ?> id;
    private E target;

    protected AbstractIdLink(Id<E> id, E target) {
        Id gid = (GenericId)id;
        if (target == null) {
            if (gid == null) {
                throw new IllegalArgumentException("Cannot create link with neither ID nor target entity!");
            }
            if (gid.getPk() == null) {
                throw new IllegalArgumentException("Cannot create link for empty ID - primary key must be present!");
            }
        } else if (gid == null) {
            gid = (GenericId)Id.from((Entity)this.target);
        }
        if (gid != null && this.isRemoveRevision()) {
            gid = gid.withoutRevision();
        }
        this.id = gid;
        this.target = target;
    }

    @Override
    public Id<E> getId() {
        if (this.id == null) {
            return this.updateId();
        }
        return this.id;
    }

    private synchronized Id<E> updateId() {
        if (this.id == null) {
            Id gid = (GenericId)Id.from((Entity)this.target);
            if (gid != null && this.isRemoveRevision()) {
                gid = gid.withoutRevision();
            }
            this.id = gid;
        }
        return this.id;
    }

    protected boolean isRemoveRevision() {
        return false;
    }

    @Override
    public boolean isResolved() {
        return this.target != null;
    }

    @Override
    public E getTarget() {
        return this.target;
    }

    protected synchronized E updateTarget(Function<Id<E>, E> resolver) {
        if (this.target == null && resolver != null) {
            this.target = resolver.apply(this.getId());
        }
        return this.target;
    }

    public AbstractIdLink<E> withType(Class<?> type) {
        Id newId = this.id.withEntityTypeGeneric((Class)type);
        if (newId == this.id) {
            return this;
        }
        return this.withId((GenericId<E, ?, ?, ?>)newId);
    }

    protected abstract AbstractIdLink<E> withId(GenericId<E, ?, ?, ?> var1);
}

