/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.entity.link;

import io.github.mmm.entity.id.GenericId;
import io.github.mmm.entity.id.Id;
import io.github.mmm.entity.link.AbstractIdLink;
import java.util.function.Function;

public class IdLink<E>
extends AbstractIdLink<E> {
    transient Function<Id<E>, E> resolver;

    protected IdLink(Id<E> id, Function<Id<E>, E> resolver) {
        this(id, null, resolver);
    }

    IdLink(Id<E> id, E target, Function<Id<E>, E> resolver) {
        super(id, target);
        this.resolver = resolver;
    }

    @Override
    public E getTarget() {
        Object target = super.getTarget();
        if (target == null && this.resolver != null && (target = this.updateTarget(this.resolver)) != null) {
            this.resolver = null;
        }
        return target;
    }

    @Override
    protected IdLink<E> withId(GenericId<E, ?, ?, ?> newId) {
        return new IdLink(newId, super.getTarget(), this.resolver);
    }

    public void setResolver(Function<Id<E>, E> resolver) {
        this.resolver = resolver;
    }

    public static <E> IdLink<E> of(Id<E> id, Function<Id<E>, E> resolver) {
        return new IdLink<E>(id, resolver);
    }
}

