/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.entity.link;

import io.github.mmm.entity.Entity;
import io.github.mmm.entity.id.Id;
import io.github.mmm.entity.link.EntityLinkWithoutRevision;
import io.github.mmm.entity.link.IdLinkWithoutRevision;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public interface Link<E> {
    public Id<E> getId();

    public boolean isResolved();

    public E getTarget();

    public static <E extends Entity> Link<E> of(E entity) {
        if (entity == null) {
            return null;
        }
        return new EntityLinkWithoutRevision<E>(entity);
    }

    public static <E> Link<E> of(Id<E> id) {
        if (id == null) {
            return null;
        }
        return new IdLinkWithoutRevision<E>(id, null);
    }

    public static <E extends Entity> Set<Link<E>> ofSet(E ... entities) {
        if (entities == null) {
            return Collections.emptySet();
        }
        HashSet<Link<E>> links = new HashSet<Link<E>>(entities.length);
        Link.ofCollection(links, entities);
        return links;
    }

    public static <E extends Entity> Set<Link<E>> ofSet(Id<E> ... ids) {
        if (ids == null) {
            return Collections.emptySet();
        }
        HashSet<Link<E>> links = new HashSet<Link<E>>(ids.length);
        Link.ofCollection(links, ids);
        return links;
    }

    public static <E extends Entity> Set<Link<E>> ofSet(Collection<E> entities) {
        if (entities == null) {
            return Collections.emptySet();
        }
        HashSet<Link<E>> links = new HashSet<Link<E>>(entities.size());
        Link.ofCollection(links, entities);
        return links;
    }

    public static <E extends Entity> List<Link<E>> ofList(E ... entities) {
        if (entities == null) {
            return Collections.emptyList();
        }
        ArrayList<Link<E>> links = new ArrayList<Link<E>>(entities.length);
        Link.ofCollection(links, entities);
        return links;
    }

    public static <E extends Entity> List<Link<E>> ofList(Id<E> ... ids) {
        if (ids == null) {
            return Collections.emptyList();
        }
        ArrayList<Link<E>> links = new ArrayList<Link<E>>(ids.length);
        Link.ofCollection(links, ids);
        return links;
    }

    public static <E extends Entity> List<Link<E>> ofList(Collection<E> entities) {
        if (entities == null) {
            return Collections.emptyList();
        }
        ArrayList<Link<E>> links = new ArrayList<Link<E>>(entities.size());
        Link.ofCollection(links, entities);
        return links;
    }

    public static <E extends Entity> void ofCollection(Collection<Link<E>> links, E ... entities) {
        if (entities == null) {
            return;
        }
        for (E entity : entities) {
            Link<E> link = Link.of(entity);
            if (link == null) continue;
            links.add(link);
        }
    }

    public static <E extends Entity> void ofCollection(Collection<Link<E>> links, Collection<E> entities) {
        if (entities == null) {
            return;
        }
        for (Entity entity : entities) {
            Link<Entity> link = Link.of(entity);
            if (link == null) continue;
            links.add(link);
        }
    }

    public static <E extends Entity> void ofCollection(Collection<Link<E>> links, Id<E> ... ids) {
        if (ids == null) {
            return;
        }
        for (Id<E> id : ids) {
            Link<E> link = Link.of(id);
            if (link == null) continue;
            links.add(link);
        }
    }

    public static <E> Id<E> getId(Link<E> link) {
        if (link != null) {
            return link.getId();
        }
        return null;
    }
}

