/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.event;

import io.github.mmm.base.exception.GlobalExceptionHandler;
import io.github.mmm.base.exception.GlobalExceptionHandlerAccess;
import io.github.mmm.event.AbstractEventSource;
import io.github.mmm.event.EventBus;
import io.github.mmm.event.EventListener;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class AbstractEventBus
implements EventBus {
    private final Map<Class<?>, EventDispatcher> eventType2dispatcherMap = new ConcurrentHashMap();
    private final Queue<Object> eventQueue = new ConcurrentLinkedQueue<Object>();
    protected final GlobalExceptionHandler errorHandler;

    public AbstractEventBus() {
        this(null);
    }

    protected AbstractEventBus(GlobalExceptionHandler errorHandler) {
        this.errorHandler = errorHandler == null ? GlobalExceptionHandlerAccess.get() : errorHandler;
    }

    @Override
    public void sendEvent(Object event) {
        Objects.requireNonNull(event);
        this.eventQueue.add(event);
        this.triggerDispatchEvents();
    }

    protected abstract void triggerDispatchEvents();

    protected void dispatchEvents() {
        Object event;
        while ((event = this.eventQueue.poll()) != null) {
            this.dispatchEvent(event);
        }
        return;
    }

    protected <E> void dispatchEvent(E event) {
        Class<?> eventType = event.getClass();
        EventDispatcher<?> eventDispatcher = this.getEventDispatcherOrNull(eventType);
        boolean dispatched = false;
        if (eventDispatcher != null) {
            dispatched = eventDispatcher.fireEvent(event);
        }
        if (!dispatched) {
            this.handleUndispatchedEvent(event);
        }
    }

    protected void handleUndispatchedEvent(Object event) {
    }

    protected <E> EventDispatcher<E> getEventDispatcherRequired(Class<E> eventType) {
        EventDispatcher dispatcher = this.eventType2dispatcherMap.get(eventType);
        if (dispatcher == null) {
            Class<E> type = eventType.getSuperclass();
            EventDispatcher parent = type != null ? this.getEventDispatcherRequired(type) : null;
            dispatcher = this.eventType2dispatcherMap.computeIfAbsent(eventType, t -> new EventDispatcher(parent));
        }
        return dispatcher;
    }

    protected <E> EventDispatcher<E> getEventDispatcherOrNull(Class<E> eventType) {
        EventDispatcher dispatcher = this.eventType2dispatcherMap.get(eventType);
        for (Class<E> type = eventType; dispatcher == null && type != null; type = type.getSuperclass()) {
            dispatcher = this.eventType2dispatcherMap.get(type);
        }
        return dispatcher;
    }

    @Override
    public <E> void addListener(Class<E> eventType, EventListener<E> listener) {
        Objects.requireNonNull(eventType);
        Objects.requireNonNull(listener);
        if (eventType.isInterface()) {
            throw new UnsupportedOperationException("This EventBus implementation does not support interfaces as event type: " + eventType.getName());
        }
        EventDispatcher<E> eventDispatcher = this.getEventDispatcherRequired(eventType);
        eventDispatcher.addListener(listener);
    }

    @Override
    public <E> boolean removeListener(Class<E> eventType, EventListener<E> listener) {
        boolean removed = false;
        if (eventType == null) {
            for (EventDispatcher dispatcher : this.eventType2dispatcherMap.values()) {
                boolean currentRemoved = dispatcher.removeListener(listener);
                if (!currentRemoved) continue;
                removed = true;
            }
        } else {
            EventDispatcher dispatcher = this.eventType2dispatcherMap.get(eventType);
            if (dispatcher != null) {
                return dispatcher.removeListener(listener);
            }
        }
        return removed;
    }

    protected class EventDispatcher<E>
    extends AbstractEventSource<E, EventListener<E>> {
        private final EventDispatcher<? super E> parentDispatcher;
        private final Collection<EventListener<E>> listeners;

        public EventDispatcher(EventDispatcher<? super E> parent) {
            this(parent, new ConcurrentLinkedQueue<EventListener<E>>());
        }

        protected EventDispatcher(EventDispatcher<? super E> parent, Collection<EventListener<E>> listeners) {
            this.parentDispatcher = parent;
            this.listeners = listeners;
        }

        @Override
        protected void doAddListener(EventListener<E> listener) {
            this.listeners.add(listener);
        }

        @Override
        public boolean removeListener(EventListener<E> listener) {
            return this.listeners.remove(listener);
        }

        @Override
        protected boolean fireEvent(E event) {
            boolean superDispatched;
            boolean dispatched = false;
            for (EventListener<E> listener : this.listeners) {
                try {
                    listener.onEvent(event);
                    dispatched = true;
                }
                catch (Throwable exception) {
                    AbstractEventBus.this.errorHandler.handleError(event, exception);
                }
            }
            if (this.parentDispatcher != null && (superDispatched = this.parentDispatcher.fireEvent(event))) {
                dispatched = true;
            }
            return dispatched;
        }
    }
}

