/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.event;

import io.github.mmm.base.exception.ReadOnlyException;
import io.github.mmm.event.EventListener;
import io.github.mmm.event.impl.WeakEventListener;
import java.util.Arrays;

public abstract class EventSourceAdapter<E, L extends EventListener<?>> {
    private static final Empty EMPTY = new Empty();
    private static final ReadOnly READ_ONLY = new ReadOnly();

    EventSourceAdapter() {
    }

    public abstract EventSourceAdapter<E, L> addListener(EventListener<? super E> var1);

    public abstract EventSourceAdapter<E, L> removeListener(EventListener<? super E> var1);

    public abstract boolean fireEvent(E var1);

    boolean fireEvent(E event, EventListener<? super E> listener) {
        try {
            listener.onEvent(event);
            return true;
        }
        catch (Exception e) {
            Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            return false;
        }
    }

    public boolean hasListeners() {
        return this.getListenerCount() > 0;
    }

    public abstract int getListenerCount();

    public abstract L getListener(int var1);

    public abstract EventListener<? super E> getRawListener(int var1);

    public static <E, L extends EventListener<?>> EventSourceAdapter<E, L> empty() {
        return EMPTY;
    }

    public static <E, L extends EventListener<?>> EventSourceAdapter<E, L> readOnly() {
        return READ_ONLY;
    }

    private static class Empty
    extends EventSourceAdapter {
        private Empty() {
        }

        public EventSourceAdapter addListener(EventListener listener) {
            return new Single(listener);
        }

        public EventSourceAdapter removeListener(EventListener listener) {
            return null;
        }

        public boolean fireEvent(Object event) {
            return false;
        }

        @Override
        public boolean hasListeners() {
            return false;
        }

        @Override
        public int getListenerCount() {
            return 0;
        }

        public EventListener getListener(int index) {
            return null;
        }

        public EventListener getRawListener(int index) {
            return null;
        }
    }

    private static class ReadOnly
    extends EventSourceAdapter {
        private ReadOnly() {
        }

        public EventSourceAdapter addListener(EventListener listener) {
            throw new ReadOnlyException(EventSourceAdapter.class);
        }

        public EventSourceAdapter removeListener(EventListener listener) {
            return null;
        }

        public boolean fireEvent(Object event) {
            return false;
        }

        @Override
        public boolean hasListeners() {
            return false;
        }

        @Override
        public int getListenerCount() {
            return 0;
        }

        public EventListener getListener(int index) {
            return null;
        }

        public EventListener getRawListener(int index) {
            return null;
        }
    }

    private static class Multi<E, L extends EventListener<? super E>>
    extends EventSourceAdapter<E, L> {
        private EventListener<? super E>[] listeners;
        private int listenerCount;
        private boolean locked;

        private Multi(EventListener<? super E> first, EventListener<? super E> second) {
            this.listeners = new EventListener[]{first, second};
            this.listenerCount = 2;
        }

        @Override
        public EventSourceAdapter<E, L> addListener(EventListener<? super E> listener) {
            int oldCapacity = this.listeners.length;
            if (this.locked) {
                int newCapacity = this.listenerCount < oldCapacity ? oldCapacity : oldCapacity * 3 / 2 + 1;
                this.listeners = Arrays.copyOf(this.listeners, newCapacity);
            } else if (this.listenerCount == oldCapacity) {
                this.listenerCount = WeakEventListener.trim(this.listenerCount, this.listeners);
                if (this.listenerCount == oldCapacity) {
                    int newCapacity = oldCapacity * 3 / 2 + 1;
                    this.listeners = Arrays.copyOf(this.listeners, newCapacity);
                }
            }
            this.listeners[this.listenerCount++] = listener;
            return this;
        }

        @Override
        public EventSourceAdapter<E, L> removeListener(EventListener<? super E> listener) {
            for (int i = 0; i < this.listenerCount; ++i) {
                int remaining;
                if (!listener.matches(this.listeners[i])) continue;
                if (this.listenerCount == 2) {
                    return new Single(this.listeners[1 - i]);
                }
                EventListener<? super E>[] oldListeners = this.listeners;
                if (this.locked) {
                    this.listeners = new EventListener[this.listeners.length];
                    System.arraycopy(oldListeners, 0, this.listeners, 0, i);
                }
                if ((remaining = this.listenerCount - i - 1) > 0) {
                    System.arraycopy(oldListeners, i + 1, this.listeners, i, remaining);
                }
                --this.listenerCount;
                if (!this.locked) {
                    this.listeners[this.listenerCount] = null;
                }
                return this;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean fireEvent(E event) {
            boolean dispatched = false;
            try {
                this.locked = true;
                for (int i = 0; i < this.listenerCount; ++i) {
                    boolean send = this.fireEvent(event, this.listeners[i]);
                    if (!send) continue;
                    dispatched = true;
                }
            }
            finally {
                this.locked = false;
            }
            return dispatched;
        }

        @Override
        public boolean hasListeners() {
            return true;
        }

        @Override
        public int getListenerCount() {
            return this.listenerCount;
        }

        @Override
        public L getListener(int index) {
            if (index >= 0 && index < this.listenerCount) {
                return (L)this.listeners[index].unwrap();
            }
            return null;
        }

        @Override
        public EventListener<? super E> getRawListener(int index) {
            if (index >= 0 && index < this.listenerCount) {
                return this.listeners[index];
            }
            return null;
        }
    }

    private static class Single<E, L extends EventListener<? super E>>
    extends EventSourceAdapter<E, L> {
        private final EventListener<? super E> listener;

        private Single(EventListener<? super E> listener) {
            this.listener = listener;
        }

        @Override
        public EventSourceAdapter<E, L> addListener(EventListener<? super E> eventListener) {
            return new Multi(this.listener, eventListener);
        }

        @Override
        public EventSourceAdapter<E, L> removeListener(EventListener<? super E> eventListener) {
            if (eventListener.matches(this.listener)) {
                return EMPTY;
            }
            return null;
        }

        @Override
        public boolean fireEvent(E event) {
            return this.fireEvent(event, this.listener);
        }

        @Override
        public boolean hasListeners() {
            return true;
        }

        @Override
        public int getListenerCount() {
            return 1;
        }

        @Override
        public L getListener(int index) {
            if (index == 0) {
                return (L)this.listener.unwrap();
            }
            return null;
        }

        @Override
        public EventListener<? super E> getRawListener(int index) {
            if (index == 0) {
                return this.listener;
            }
            return null;
        }
    }
}

