/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.event.impl;

import io.github.mmm.event.EventListener;
import io.github.mmm.event.EventSource;
import java.lang.ref.WeakReference;
import java.util.Objects;

public class WeakEventListener<E>
implements EventListener<E> {
    private final EventSource source;
    public final WeakReference<EventListener<E>> ref;

    public WeakEventListener(EventSource<E, ?> source, EventListener<E> listener) {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(listener, "listener");
        this.source = source;
        this.ref = new WeakReference<EventListener<E>>(listener);
    }

    public boolean wasGarbageCollected() {
        return this.ref.get() == null;
    }

    @Override
    public void onEvent(E event) {
        EventListener listener = (EventListener)this.ref.get();
        if (listener != null) {
            listener.onEvent(event);
        } else {
            this.source.removeListener(this);
        }
    }

    @Override
    public EventListener<E> weak(EventSource<E, ?> eventSource) {
        assert (eventSource == this.source);
        return this;
    }

    @Override
    public EventListener<E> unwrap() {
        return (EventListener)this.ref.get();
    }

    public static int trim(int count, EventListener<?>[] listeners) {
        for (int i = 0; i < count; ++i) {
            if (!(listeners[i] instanceof WeakEventListener) || !((WeakEventListener)listeners[i]).wasGarbageCollected()) continue;
            int remaining = count - i - 1;
            if (remaining > 0) {
                System.arraycopy(listeners, i + 1, listeners, i, remaining);
            }
            listeners[--count] = null;
            --i;
        }
        return count;
    }
}

