/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.marshall;

import io.github.mmm.marshall.StructuredFormat;
import io.github.mmm.marshall.spi.AbstractStructuredWriter;
import io.github.mmm.marshall.spi.StructuredNode;
import java.io.IOException;

public abstract class AbstractStructuredStringWriter<S extends StructuredNode<S>>
extends AbstractStructuredWriter<S> {
    protected Appendable out;
    private String comment;
    private boolean newlineWritten;

    public AbstractStructuredStringWriter(Appendable out, StructuredFormat format) {
        super(format);
        this.out = out;
    }

    protected void writeIndent() {
        if (this.comment != null && this.getFormat().isSupportingComments()) {
            this.writeIndent(this.indentCount);
            this.doWriteComment(this.comment);
            this.comment = null;
        }
        this.writeIndent(this.indentCount);
    }

    private void writeIndent(int count) {
        if (this.indentation == null) {
            return;
        }
        try {
            if (this.newlineWritten) {
                this.out.append('\n');
            } else {
                this.newlineWritten = true;
            }
            for (int i = count; i > 0; --i) {
                this.out.append(this.indentation);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void write(char data) {
        try {
            this.out.append(data);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void write(String data) {
        try {
            this.out.append(data);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void writeComment(String newComment) {
        if (newComment == null) {
            return;
        }
        this.comment = this.comment == null ? newComment : this.comment + "\n" + newComment;
    }

    protected void doWriteComment(String currentComment) {
    }

    @Override
    protected void doClose() {
        if (this.out instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)this.out)).close();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        this.out = null;
    }

    public String toString() {
        return this.out.toString();
    }
}

