/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.marshall;

import io.github.mmm.base.variable.VariableDefinition;
import io.github.mmm.base.variable.VariableMap;
import io.github.mmm.marshall.EnumFormat;
import io.github.mmm.marshall.id.StructuredIdMappingProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class MarshallingConfig
extends VariableMap {
    public static final VariableDefinition<String> VAR_INDENTATION = new VariableDefinition("indentation", (Object)"  ");
    public static final VariableDefinition<Boolean> VAR_WRITE_NULL_VALUES = new VariableDefinition("write-null", (Object)Boolean.TRUE);
    public static final VariableDefinition<Boolean> VAR_UNQUOTED_PROPERTIES = new VariableDefinition("unquoted-properties", null);
    public static final VariableDefinition<EnumFormat> VAR_ENUM_FORMAT = new VariableDefinition("enum-format", (Object)EnumFormat.ORDINAL);
    public static final VariableDefinition<Boolean> VAR_ENCODE_ROOT_OBJECT = new VariableDefinition("root-object", Boolean.class);
    public static final VariableDefinition<StructuredIdMappingProvider> VAR_ID_MAPPING_PROVIDER = new VariableDefinition("id-mapping-provider", null);
    public static final MarshallingConfig DEFAULTS = new MarshallingConfig(Collections.emptyMap());
    public static final MarshallingConfig NO_INDENTATION = DEFAULTS.with(VAR_INDENTATION, null);
    private static final Set<String> STANDARD_KEYS = Set.of(VAR_INDENTATION.getName(), VAR_WRITE_NULL_VALUES.getName(), VAR_ENUM_FORMAT.getName(), VAR_UNQUOTED_PROPERTIES.getName());

    public MarshallingConfig() {
    }

    public MarshallingConfig(Map<String, Object> map) {
        super(map);
    }

    public <T> MarshallingConfig with(VariableDefinition<T> option, T value) {
        Object oldValue = this.get(option);
        if (Objects.equals(oldValue, value)) {
            return this;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(this.getMap());
        map.put(option.getName(), value);
        return new MarshallingConfig(map);
    }

    public MarshallingConfig with(String key, Object value) {
        Object oldValue = this.getMap().get(key);
        if (Objects.equals(oldValue, value)) {
            return this;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(this.getMap());
        map.put(key, value);
        return new MarshallingConfig(map);
    }

    public static boolean isProprietary(String key) {
        return !STANDARD_KEYS.contains(key);
    }
}

