/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.marshall;

import io.github.mmm.marshall.MarshallingConfig;
import io.github.mmm.marshall.StructuredBinaryFormat;
import io.github.mmm.marshall.StructuredFormat;
import io.github.mmm.marshall.StructuredFormatProvider;
import io.github.mmm.marshall.StructuredTextFormat;
import io.github.mmm.marshall.impl.StructuredFormatFactoryImpl;

public interface StructuredFormatFactory {
    public StructuredFormatProvider getProvider(String var1);

    default public StructuredFormat create(String formatId) {
        return this.create(formatId, null);
    }

    default public StructuredFormat create(String formatId, MarshallingConfig config) {
        return this.getProvider(formatId).create(config);
    }

    default public StructuredTextFormat createText(String formatId) {
        return this.createText(formatId, null);
    }

    default public StructuredTextFormat createText(String formatId, MarshallingConfig config) {
        StructuredFormat format = this.getProvider(formatId).create(config);
        if (!format.isText()) {
            throw new IllegalStateException("Format is not text: " + formatId);
        }
        return (StructuredTextFormat)format;
    }

    default public StructuredBinaryFormat createBinary(String formatId) {
        return this.createBinary(formatId, null);
    }

    default public StructuredBinaryFormat createBinary(String formatId, MarshallingConfig config) {
        StructuredFormat format = this.getProvider(formatId).create(config);
        if (!format.isBinary()) {
            throw new IllegalStateException("Format is not binary: " + formatId);
        }
        return (StructuredBinaryFormat)format;
    }

    public static StructuredFormatFactory get() {
        return StructuredFormatFactoryImpl.INSTANCE;
    }
}

