/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.marshall;

import io.github.mmm.base.exception.ObjectMismatchException;
import io.github.mmm.marshall.StructuredProcessor;
import io.github.mmm.marshall.StructuredState;
import io.github.mmm.marshall.id.StructuredIdMapping;
import io.github.mmm.marshall.id.StructuredIdMappingObject;
import io.github.mmm.marshall.id.impl.StructuredIdMappingIdentity;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public interface StructuredReader
extends StructuredProcessor,
StructuredIdMappingObject {
    default public String readName() {
        this.require(StructuredState.NAME, true);
        return this.getName();
    }

    @Override
    public String getName();

    default public String getName(boolean next) {
        if (next) {
            this.require(StructuredState.NAME, next);
        }
        return this.getName();
    }

    default public boolean isName(String name) {
        return this.isName(name, true);
    }

    default public boolean isName(String name, boolean next) {
        boolean match = this.isNameMatching(this.getName(), name);
        if (match && next) {
            this.next();
        }
        return match;
    }

    default public boolean isNameMatching(String name, String expectedName) {
        return Objects.equals(name, expectedName);
    }

    public boolean readStartObject(StructuredIdMappingObject var1);

    default public void specializeObject(StructuredIdMappingObject object) {
    }

    public boolean readStartArray();

    public Object readValue();

    public Object readValue(boolean var1);

    public void readObject(Map<String, Object> var1);

    public void readArray(Collection<Object> var1);

    default public <V> V readValue(Class<V> type) {
        Object value;
        Objects.requireNonNull(type, "type");
        if (type.equals(String.class)) {
            value = this.readValueAsString();
        } else if (Boolean.class.equals(type)) {
            value = this.readValueAsBoolean();
        } else if (Integer.class.equals(type)) {
            value = this.readValueAsInteger();
        } else if (Long.class.equals(type)) {
            value = this.readValueAsLong();
        } else if (Short.class.equals(type)) {
            value = this.readValueAsShort();
        } else if (Byte.class.equals(type)) {
            value = this.readValueAsByte();
        } else if (Double.class.equals(type)) {
            value = this.readValueAsDouble();
        } else if (Float.class.equals(type)) {
            value = this.readValueAsFloat();
        } else if (BigInteger.class.equals(type)) {
            value = this.readValueAsBigInteger();
        } else if (BigDecimal.class.equals(type)) {
            value = this.readValueAsBigDecimal();
        } else if (Instant.class.equals(type)) {
            value = this.readValueAsInstant();
        } else if (LocalDateTime.class.equals(type)) {
            value = this.readValueAsLocalDateTime();
        } else if (LocalDate.class.equals(type)) {
            value = this.readValueAsLocalDate();
        } else if (LocalTime.class.equals(type)) {
            value = this.readValueAsLocalTime();
        } else if (ZonedDateTime.class.equals(type)) {
            value = this.readValueAsZonedDateTime();
        } else if (OffsetDateTime.class.equals(type)) {
            value = this.readValueAsOffsetDateTime();
        } else if (OffsetTime.class.equals(type)) {
            value = this.readValueAsOffsetTime();
        } else if (type.isEnum()) {
            value = this.readValueAsEnum(type);
        } else if (Object.class.equals(type)) {
            value = this.readValue();
        } else {
            throw new IllegalArgumentException("Unsupported value type " + String.valueOf(type));
        }
        return type.cast(value);
    }

    public String readValueAsString();

    public Boolean readValueAsBoolean();

    public <E extends Enum<E>> E readValueAsEnum(Class<E> var1);

    public Integer readValueAsInteger();

    public Long readValueAsLong();

    public Double readValueAsDouble();

    public Float readValueAsFloat();

    public Short readValueAsShort();

    public Byte readValueAsByte();

    public BigInteger readValueAsBigInteger();

    public BigDecimal readValueAsBigDecimal();

    public Instant readValueAsInstant();

    public LocalDate readValueAsLocalDate();

    public LocalDateTime readValueAsLocalDateTime();

    public LocalTime readValueAsLocalTime();

    public ZonedDateTime readValueAsZonedDateTime();

    public OffsetDateTime readValueAsOffsetDateTime();

    public OffsetTime readValueAsOffsetTime();

    public void skipValue();

    public boolean readEnd();

    default public boolean readEndObject() {
        if (this.getState() == StructuredState.END_OBJECT) {
            this.next();
            return true;
        }
        return false;
    }

    default public boolean readEndArray() {
        if (this.getState() == StructuredState.END_ARRAY) {
            this.next();
            return true;
        }
        return false;
    }

    public boolean isDone();

    public boolean isStringValue();

    public StructuredState next();

    default public void require(StructuredState expected) {
        this.require(expected, false);
    }

    default public StructuredState require(StructuredState expected, boolean next) {
        StructuredState currentState = this.getState();
        if (currentState != expected && currentState != StructuredState.NULL) {
            throw new ObjectMismatchException((Object)currentState, (Object)expected);
        }
        if (next) {
            return this.next();
        }
        return currentState;
    }

    default public String readComment() {
        return null;
    }

    @Override
    default public StructuredIdMapping defineIdMapping() {
        return StructuredIdMappingIdentity.get();
    }

    @Override
    default public Object asTypeKey() {
        return StructuredReader.class;
    }
}

