/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.marshall;

import io.github.mmm.marshall.spi.StructuredNodeType;

public enum StructuredState {
    NULL{

        @Override
        public boolean isValidTransition(StructuredState target, StructuredNodeType type) {
            return target == VALUE || target == DONE | target.isStart();
        }
    }
    ,
    START_ARRAY{

        @Override
        public boolean isValidTransition(StructuredState target, StructuredNodeType type) {
            return target == VALUE || target == END_ARRAY || target.isStart();
        }
    }
    ,
    START_OBJECT{

        @Override
        public boolean isValidTransition(StructuredState target, StructuredNodeType type) {
            return target == NAME || target == END_OBJECT;
        }
    }
    ,
    VALUE,
    NAME{

        @Override
        public boolean isValidTransition(StructuredState target, StructuredNodeType type) {
            return target == VALUE || target.isStart();
        }
    }
    ,
    END_ARRAY,
    END_OBJECT,
    DONE{

        @Override
        public boolean isValidTransition(StructuredState target, StructuredNodeType type) {
            return false;
        }
    };


    public boolean isStart() {
        switch (this.ordinal()) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public boolean isEnd() {
        switch (this.ordinal()) {
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public int getDepthDelta() {
        switch (this.ordinal()) {
            case 1: 
            case 2: {
                return 1;
            }
            case 5: 
            case 6: 
            case 7: {
                return -1;
            }
        }
        return 0;
    }

    public boolean isValidTransition(StructuredState target, StructuredNodeType type) {
        if (type == null && target == DONE) {
            return true;
        }
        if (type == StructuredNodeType.ARRAY) {
            return target == VALUE || target == END_ARRAY || target.isStart();
        }
        if (type == StructuredNodeType.OBJECT) {
            return target == NAME || target == END_OBJECT;
        }
        return false;
    }
}

