/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.marshall;

import io.github.mmm.marshall.MarshallableObject;
import io.github.mmm.marshall.StructuredFormat;
import io.github.mmm.marshall.StructuredReader;
import io.github.mmm.marshall.StructuredWriter;
import io.github.mmm.marshall.UnmarshallableObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;

public interface StructuredTextFormat
extends StructuredFormat {
    public StructuredReader reader(Reader var1);

    default public StructuredReader reader(String data) {
        return this.reader(new StringReader(data));
    }

    @Override
    default public StructuredReader reader(InputStream in) {
        return this.reader(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    @Override
    default public StructuredReader reader(Object data) {
        if (data instanceof CharSequence) {
            return this.reader(data.toString());
        }
        return StructuredFormat.super.reader(data);
    }

    default public void read(String data, UnmarshallableObject object) {
        StructuredReader reader = this.reader(data);
        object.read(reader);
        reader.close();
    }

    public StructuredWriter writer(Appendable var1);

    @Override
    default public StructuredWriter writer(OutputStream out) {
        return this.writer(new OutputStreamWriter(out, StandardCharsets.UTF_8));
    }

    default public String write(MarshallableObject object) {
        if (object == null) {
            return null;
        }
        StringBuilder writer = new StringBuilder(512);
        StructuredWriter structuredWriter = this.writer(writer);
        object.write(structuredWriter);
        structuredWriter.close();
        return writer.toString();
    }

    @Override
    default public boolean isBinary() {
        return false;
    }
}

