/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.marshall;

import io.github.mmm.marshall.MarshallableObject;
import io.github.mmm.marshall.StructuredProcessor;
import io.github.mmm.marshall.StructuredReader;
import io.github.mmm.marshall.id.StructuredIdMappingObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;

public interface StructuredWriter
extends StructuredProcessor {
    public void writeStartArray();

    public void writeStartObject(StructuredIdMappingObject var1);

    public void writeEnd();

    public void writeName(String var1);

    default public void writeValue(Object value) {
        if (value == null) {
            this.writeValueAsNull();
        } else if (value instanceof String) {
            this.writeValueAsString(value.toString());
        } else if (value instanceof Boolean) {
            this.writeValueAsBoolean((boolean)((Boolean)value));
        } else if (value instanceof Number) {
            this.writeValueAsNumber((Number)value);
        } else if (value instanceof Enum) {
            this.writeValueAsEnum((Enum)value);
        } else if (value instanceof Temporal) {
            if (value instanceof Instant) {
                this.writeValueAsInstant((Instant)value);
            } else if (value instanceof LocalDateTime) {
                this.writeValueAsLocalDateTime((LocalDateTime)value);
            } else if (value instanceof LocalDate) {
                this.writeValueAsLocalDate((LocalDate)value);
            } else if (value instanceof LocalTime) {
                this.writeValueAsLocalTime((LocalTime)value);
            } else if (value instanceof ZonedDateTime) {
                this.writeValueAsZonedDateTime((ZonedDateTime)value);
            } else if (value instanceof OffsetDateTime) {
                this.writeValueAsOffsetDateTime((OffsetDateTime)value);
            } else if (value instanceof OffsetTime) {
                this.writeValueAsOffsetTime((OffsetTime)value);
            } else {
                this.writeValueAsString(value.toString());
            }
        } else if (value instanceof MarshallableObject) {
            ((MarshallableObject)value).write(this);
        } else {
            this.writeValueAsString(value.toString());
        }
    }

    default public void writeValueAsNumber(Number value) {
        if (value == null) {
            this.writeValueAsNull();
        } else if (value instanceof Long) {
            this.writeValueAsLong(value.longValue());
        } else if (value instanceof Integer) {
            this.writeValueAsInteger(value.intValue());
        } else if (value instanceof Double) {
            this.writeValueAsDouble(value.doubleValue());
        } else if (value instanceof BigDecimal) {
            this.writeValueAsBigDecimal((BigDecimal)value);
        } else if (value instanceof BigInteger) {
            this.writeValueAsBigInteger((BigInteger)value);
        } else if (value instanceof Float) {
            this.writeValueAsFloat(value.floatValue());
        } else if (value instanceof Short) {
            this.writeValueAsShort(value.shortValue());
        } else if (value instanceof Byte) {
            this.writeValueAsByte(value.byteValue());
        } else {
            this.writeValueAsDouble(value.doubleValue());
        }
    }

    public void writeValueAsNull();

    public void writeValueAsEnum(Enum<?> var1);

    default public void writeValueAsInstant(Instant value) {
        if (value == null) {
            this.writeValueAsNull();
        } else {
            this.writeValueAsString(value.toString());
        }
    }

    default public void writeValueAsLocalDateTime(LocalDateTime value) {
        if (value == null) {
            this.writeValueAsNull();
        } else {
            this.writeValueAsString(value.toString());
        }
    }

    default public void writeValueAsLocalDate(LocalDate value) {
        if (value == null) {
            this.writeValueAsNull();
        } else {
            this.writeValueAsString(value.toString());
        }
    }

    default public void writeValueAsLocalTime(LocalTime value) {
        if (value == null) {
            this.writeValueAsNull();
        } else {
            this.writeValueAsString(value.toString());
        }
    }

    default public void writeValueAsZonedDateTime(ZonedDateTime value) {
        if (value == null) {
            this.writeValueAsNull();
        } else {
            this.writeValueAsString(value.toString());
        }
    }

    default public void writeValueAsOffsetDateTime(OffsetDateTime value) {
        if (value == null) {
            this.writeValueAsNull();
        } else {
            this.writeValueAsString(value.toString());
        }
    }

    default public void writeValueAsOffsetTime(OffsetTime value) {
        if (value == null) {
            this.writeValueAsNull();
        } else {
            this.writeValueAsString(value.toString());
        }
    }

    public void writeValueAsString(String var1);

    public void writeValueAsBoolean(Boolean var1);

    public void writeValueAsBoolean(boolean var1);

    default public void writeValueAsBigDecimal(BigDecimal value) {
        this.writeValueAsNumber(value);
    }

    default public void writeValueAsBigInteger(BigInteger value) {
        this.writeValueAsNumber(value);
    }

    default public void writeValueAsLong(Long value) {
        this.writeValueAsNumber(value);
    }

    default public void writeValueAsLong(long value) {
        this.writeValueAsNumber(value);
    }

    default public void writeValueAsInteger(Integer value) {
        this.writeValueAsNumber(value);
    }

    default public void writeValueAsInteger(int value) {
        this.writeValueAsNumber(value);
    }

    default public void writeValueAsShort(Short value) {
        this.writeValueAsNumber(value);
    }

    default public void writeValueAsShort(short value) {
        this.writeValueAsInteger(value);
    }

    default public void writeValueAsByte(Byte value) {
        this.writeValueAsNumber(value);
    }

    default public void writeValueAsByte(byte value) {
        this.writeValueAsInteger(value);
    }

    default public void writeValueAsDouble(Double value) {
        this.writeValueAsNumber(value);
    }

    default public void writeValueAsDouble(double value) {
        this.writeValueAsNumber(value);
    }

    default public void writeValueAsFloat(Float value) {
        this.writeValueAsNumber(value);
    }

    default public void writeValueAsFloat(float value) {
        this.writeValueAsNumber(Float.valueOf(value));
    }

    default public void writeComment(String comment) {
    }

    public void write(StructuredReader var1);
}

