/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.marshall.impl;

import io.github.mmm.base.text.CaseHelper;
import io.github.mmm.base.text.CaseSyntax;
import java.util.HashMap;
import java.util.Map;

public class EnumMapping<E extends Enum<E>> {
    private final Map<String, E> string2enumMap;
    private final Map<Integer, E> ordinal2enumMap = new HashMap<Integer, E>();

    public EnumMapping(Class<E> enumType) {
        this.string2enumMap = new HashMap<String, E>();
        for (Enum e : (Enum[])enumType.getEnumConstants()) {
            this.ordinal2enumMap.put(e.ordinal(), e);
            this.string2enumMap.put(e.name(), e);
            String string = e.toString();
            this.string2enumMap.putIfAbsent(string, e);
            this.string2enumMap.putIfAbsent(CaseHelper.toLowerCase((String)string), e);
            this.string2enumMap.putIfAbsent(CaseSyntax.TRAIN_CASE.convert(string), e);
        }
    }

    public E fromString(String value) {
        return (E)((Enum)this.string2enumMap.get(value));
    }

    public E fromOrdinal(Integer ordinal) {
        return (E)((Enum)this.ordinal2enumMap.get(ordinal));
    }
}

