/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.marshall.impl;

import io.github.mmm.base.exception.ObjectNotFoundException;
import io.github.mmm.base.service.ServiceHelper;
import io.github.mmm.marshall.AbstractStructuredFormatProvider;
import io.github.mmm.marshall.StructuredFormatFactory;
import io.github.mmm.marshall.StructuredFormatProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructuredFormatFactoryImpl
implements StructuredFormatFactory {
    private static final Logger LOG = LoggerFactory.getLogger(StructuredFormatFactoryImpl.class);
    public static final StructuredFormatFactoryImpl INSTANCE = new StructuredFormatFactoryImpl();
    private final Map<String, StructuredFormatProvider> providerMap = new HashMap<String, StructuredFormatProvider>();
    private final Map<String, StructuredFormatProvider> aliasMap = new HashMap<String, StructuredFormatProvider>();

    protected StructuredFormatFactoryImpl() {
        ServiceHelper.all(ServiceLoader.load(StructuredFormatProvider.class), this.providerMap, StructuredFormatProvider::getId);
        for (StructuredFormatProvider provider : this.providerMap.values()) {
            if (!(provider instanceof AbstractStructuredFormatProvider)) continue;
            AbstractStructuredFormatProvider asfp = (AbstractStructuredFormatProvider)provider;
            for (String alias : asfp.getAliases()) {
                StructuredFormatProvider duplicate = this.aliasMap.put(alias, provider);
                if (duplicate == null) continue;
                LOG.warn("Duplicate alias {} used by {} and {}", new Object[]{alias, duplicate, provider});
            }
        }
    }

    @Override
    public StructuredFormatProvider getProvider(String format) {
        StructuredFormatProvider provider = this.providerMap.get(format);
        if (provider == null && (provider = this.aliasMap.get(format)) == null) {
            throw new ObjectNotFoundException((Object)"StructuredFormatProvider", (Object)format);
        }
        return provider;
    }
}

