/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.marshall.spi;

import io.github.mmm.base.exception.RuntimeIoException;
import io.github.mmm.marshall.EnumFormat;
import io.github.mmm.marshall.MarshallingConfig;
import io.github.mmm.marshall.StructuredFormat;
import io.github.mmm.marshall.StructuredProcessor;
import io.github.mmm.marshall.StructuredState;
import io.github.mmm.marshall.id.StructuredIdMappingObject;
import io.github.mmm.marshall.spi.StructuredNode;
import io.github.mmm.marshall.spi.StructuredNodeType;
import java.io.IOException;

public abstract class AbstractStructuredProcessor<S extends StructuredNode<S>>
implements StructuredProcessor {
    private final StructuredFormat format;
    protected final MarshallingConfig config;
    protected final EnumFormat enumFormat;
    protected String name;
    StructuredState state;
    protected S node;

    public AbstractStructuredProcessor(StructuredFormat format) {
        this.format = format;
        this.config = format.getConfig();
        this.enumFormat = (EnumFormat)((Object)this.config.get(MarshallingConfig.VAR_ENUM_FORMAT));
        this.state = StructuredState.NULL;
        this.node = this.newNode(null, null);
    }

    protected abstract S newNode(StructuredNodeType var1, StructuredIdMappingObject var2);

    @Override
    public StructuredFormat getFormat() {
        return this.format;
    }

    @Override
    public StructuredState getState() {
        return this.state;
    }

    protected StructuredState setState(StructuredState newState) {
        StructuredNodeType type;
        if (!(newState == StructuredState.NULL || this.node == null || this.state == StructuredState.NULL && ((StructuredNode)this.node).parent != null || this.state.isValidTransition(newState, type = ((StructuredNode)this.node).getType()))) {
            StringBuilder sb = new StringBuilder(type == null ? 56 : 72);
            sb.append("Invalid transition from state ");
            sb.append((Object)this.state);
            sb.append(" to ");
            sb.append((Object)newState);
            if (type != null) {
                sb.append(" in parent ");
                sb.append((Object)type);
            }
            if (this.name != null) {
                sb.append(" at property ");
                sb.append(this.name);
                int id = this.getId();
                if (id > 0) {
                    sb.append('[');
                    sb.append(id);
                    sb.append(']');
                }
            }
            sb.append('!');
            throw new IllegalStateException(sb.toString());
        }
        this.state = newState;
        return this.state;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getId() {
        return 0;
    }

    @Override
    public final void close() {
        if (this.node != null) {
            try {
                this.doClose();
            }
            catch (IOException e) {
                throw new RuntimeIoException((Throwable)e);
            }
        }
        this.state = StructuredState.DONE;
        this.node = null;
    }

    protected abstract void doClose() throws IOException;
}

