/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.marshall.spi;

import io.github.mmm.base.number.NumberType;
import io.github.mmm.marshall.StructuredFormat;
import io.github.mmm.marshall.StructuredReader;
import io.github.mmm.marshall.StructuredState;
import io.github.mmm.marshall.id.StructuredIdMappingObject;
import io.github.mmm.marshall.impl.EnumMapping;
import io.github.mmm.marshall.impl.EnumMappings;
import io.github.mmm.marshall.spi.AbstractStructuredProcessor;
import io.github.mmm.marshall.spi.StructuredNode;
import io.github.mmm.marshall.spi.StructuredNodeType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractStructuredReader<S extends StructuredNode<S>>
extends AbstractStructuredProcessor<S>
implements StructuredReader {
    private String comment;
    private boolean done;

    public AbstractStructuredReader(StructuredFormat format) {
        super(format);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean readStartObject(StructuredIdMappingObject object) {
        if (this.state == StructuredState.START_OBJECT) {
            this.next();
            return true;
        }
        return false;
    }

    @Override
    public boolean readStartArray() {
        if (this.state == StructuredState.START_ARRAY) {
            this.next();
            return true;
        }
        return false;
    }

    @Override
    public boolean readEnd() {
        if (this.state == StructuredState.DONE) {
            boolean result = !this.done;
            this.done = true;
            return result;
        }
        if (this.state == StructuredState.END_ARRAY || this.state == StructuredState.END_OBJECT) {
            this.next();
            return true;
        }
        return false;
    }

    @Override
    public boolean isDone() {
        return this.state == StructuredState.DONE;
    }

    protected StructuredState start(StructuredNodeType type) {
        StructuredState newState = type.getStart();
        this.setState(newState);
        this.node = this.newNode(type, null);
        return newState;
    }

    protected StructuredState end(StructuredNodeType type) {
        StructuredState newState;
        if (type != null && this.node.type != type) {
            throw new IllegalStateException();
        }
        if (this.node.type != null) {
            newState = this.node.type.getEnd();
            this.setState(newState);
            this.node = this.node.parent;
        } else {
            assert (this.node.parent == null);
            newState = this.setState(StructuredState.DONE);
        }
        return newState;
    }

    protected void require(StructuredState expected, StructuredState expected2) {
        if (this.state != expected && this.state != expected2) {
            this.error("Expecting event " + String.valueOf((Object)expected) + " or " + String.valueOf((Object)expected2) + " but found " + String.valueOf((Object)this.state) + ".");
        }
    }

    protected void require(StructuredState expected, StructuredState expected2, StructuredState expected3) {
        if (this.state != expected && this.state != expected2 && this.state != expected3) {
            this.error("Expecting event " + String.valueOf((Object)expected) + ", " + String.valueOf((Object)expected2) + ",  or " + String.valueOf((Object)expected3) + " but found " + String.valueOf((Object)this.state) + ".");
        }
    }

    protected void requireNot(StructuredState unexpected) {
        if (this.state == unexpected) {
            this.error("Unexpected event " + String.valueOf((Object)unexpected) + ".");
        }
    }

    @Override
    public String readValueAsString() {
        Object v = this.readValue();
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    @Override
    public Boolean readValueAsBoolean() {
        Object v = this.readValue();
        if (v == null) {
            return null;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            return this.parseBoolean((String)v);
        }
        throw this.error(v, Boolean.class);
    }

    @Override
    public <E extends Enum<E>> E readValueAsEnum(Class<E> enumType) {
        EnumMapping<E> mapping = EnumMappings.get().getMapping(enumType);
        if (this.isStringValue()) {
            String stringValue = this.readValueAsString();
            E e = mapping.fromString(stringValue);
            if (e == null && stringValue != null) {
                throw this.error("The string value '" + stringValue + "' is not an enum of type " + enumType.getName());
            }
            return e;
        }
        Integer ordinalValue = this.readValueAsInteger();
        if (ordinalValue == null) {
            return null;
        }
        E e = mapping.fromOrdinal(ordinalValue);
        if (e == null && ordinalValue != null) {
            throw this.error("The integer value '" + ordinalValue + "' is not an ordinal of enum type " + enumType.getName());
        }
        return e;
    }

    @Override
    public Long readValueAsLong() {
        return (Long)this.readValueAsNumber(NumberType.LONG);
    }

    @Override
    public Integer readValueAsInteger() {
        return (Integer)this.readValueAsNumber(NumberType.INTEGER);
    }

    @Override
    public Short readValueAsShort() {
        return (Short)this.readValueAsNumber(NumberType.SHORT);
    }

    @Override
    public Byte readValueAsByte() {
        return (Byte)this.readValueAsNumber(NumberType.BYTE);
    }

    @Override
    public Double readValueAsDouble() {
        return (Double)this.readValueAsNumber(NumberType.DOUBLE);
    }

    @Override
    public Float readValueAsFloat() {
        return (Float)this.readValueAsNumber(NumberType.FLOAT);
    }

    @Override
    public BigInteger readValueAsBigInteger() {
        return (BigInteger)this.readValueAsNumber(NumberType.BIG_INTEGER);
    }

    @Override
    public BigDecimal readValueAsBigDecimal() {
        return (BigDecimal)this.readValueAsNumber(NumberType.BIG_DECIMAL);
    }

    protected abstract <N extends Number> N readValueAsNumber(NumberType<N> var1);

    protected Number parseNumber(String string) {
        boolean decimal;
        boolean bl = decimal = string.indexOf(46) >= 0;
        if (decimal) {
            BigDecimal bd = new BigDecimal(string);
            if (string.endsWith("0")) {
                return bd;
            }
            return NumberType.simplify((Number)bd, (NumberType)NumberType.FLOAT);
        }
        BigInteger integer = new BigInteger(string);
        int bitLength = integer.bitLength();
        if (bitLength > 63) {
            return integer;
        }
        if (bitLength < 31) {
            return integer.intValue();
        }
        return integer.longValue();
    }

    protected Boolean parseBoolean(String string) {
        if (string == null) {
            return null;
        }
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        if (string.isEmpty()) {
            return null;
        }
        throw this.error(string, Boolean.class, null);
    }

    @Override
    public Instant readValueAsInstant() {
        String value = this.readValueAsString();
        if (value == null) {
            return null;
        }
        try {
            return Instant.parse(value);
        }
        catch (RuntimeException e) {
            throw this.error(value, Instant.class, e);
        }
    }

    @Override
    public LocalDate readValueAsLocalDate() {
        String value = this.readValueAsString();
        if (value == null) {
            return null;
        }
        try {
            return LocalDate.parse(value);
        }
        catch (RuntimeException e) {
            throw this.error(value, LocalDate.class, e);
        }
    }

    @Override
    public LocalDateTime readValueAsLocalDateTime() {
        String value = this.readValueAsString();
        if (value == null) {
            return null;
        }
        try {
            return LocalDateTime.parse(value);
        }
        catch (RuntimeException e) {
            throw this.error(value, LocalDateTime.class, e);
        }
    }

    @Override
    public LocalTime readValueAsLocalTime() {
        String value = this.readValueAsString();
        if (value == null) {
            return null;
        }
        try {
            return LocalTime.parse(value);
        }
        catch (RuntimeException e) {
            throw this.error(value, LocalTime.class, e);
        }
    }

    @Override
    public ZonedDateTime readValueAsZonedDateTime() {
        String value = this.readValueAsString();
        if (value == null) {
            return null;
        }
        try {
            return ZonedDateTime.parse(value);
        }
        catch (RuntimeException e) {
            throw this.error(value, ZonedDateTime.class, e);
        }
    }

    @Override
    public OffsetDateTime readValueAsOffsetDateTime() {
        String value = this.readValueAsString();
        if (value == null) {
            return null;
        }
        try {
            return OffsetDateTime.parse(value);
        }
        catch (RuntimeException e) {
            throw this.error(value, OffsetDateTime.class, e);
        }
    }

    @Override
    public OffsetTime readValueAsOffsetTime() {
        String value = this.readValueAsString();
        if (value == null) {
            return null;
        }
        try {
            return OffsetTime.parse(value);
        }
        catch (RuntimeException e) {
            throw this.error(value, OffsetDateTime.class, e);
        }
    }

    @Override
    public Object readValue(boolean recursive) {
        Cloneable value;
        if (this.state == StructuredState.VALUE || !recursive) {
            return this.readValue();
        }
        if (this.state == StructuredState.START_ARRAY) {
            ArrayList<Object> array = new ArrayList<Object>();
            this.readArray(array);
            value = array;
        } else if (this.state == StructuredState.START_OBJECT) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.readObject(map);
            value = map;
        } else {
            this.require(StructuredState.VALUE, StructuredState.START_ARRAY, StructuredState.START_OBJECT);
            throw this.errorIllegalState();
        }
        return value;
    }

    @Override
    public void readObject(Map<String, Object> map) {
        this.require(StructuredState.START_OBJECT);
        this.next();
        while (this.state != StructuredState.END_OBJECT) {
            String key = this.readName();
            Object value = this.readValue(true);
            map.put(key, value);
        }
        this.next();
    }

    @Override
    public void readArray(Collection<Object> array) {
        this.require(StructuredState.START_ARRAY);
        this.next();
        while (this.state != StructuredState.END_ARRAY) {
            Object value = this.readValue(true);
            array.add(value);
        }
        this.next();
    }

    @Override
    public String readComment() {
        String result = this.comment;
        if (result != null) {
            this.comment = null;
        }
        return result;
    }

    protected String unescapeXmlComment(String currentComment) {
        return currentComment.replace("\\-_-/", "--");
    }

    protected void addComment(String newComment) {
        this.comment = this.comment == null ? newComment : this.comment + "\n" + newComment;
    }

    @Override
    public final StructuredState next() {
        return this.next(false);
    }

    protected abstract StructuredState next(boolean var1);

    @Override
    public void skipValue() {
        this.require(StructuredState.VALUE, StructuredState.START_ARRAY, StructuredState.START_OBJECT);
        if (this.state == StructuredState.VALUE) {
            this.next(false);
            return;
        }
        this.next(true);
    }

    protected RuntimeException errorIllegalState() {
        return this.error("Illegal state");
    }

    protected RuntimeException error(String message) {
        return this.error(message, (Throwable)null);
    }

    protected RuntimeException error(String message, Throwable cause) {
        throw new IllegalStateException(this.appendContextDetails(message), cause);
    }

    protected String appendContextDetails(String message) {
        if (this.name == null) {
            return message;
        }
        return message + "(at property '" + this.name + "')";
    }

    protected RuntimeException error(Object value, Class<?> typeClass) {
        return this.error(value, typeClass, null);
    }

    protected RuntimeException error(Object value, Class<?> typeClass, Throwable cause) {
        StringBuilder message = new StringBuilder("Failed to parse ");
        if (value == null) {
            message.append("null");
        } else {
            message.append("'");
            message.append(value);
            message.append("'");
            if (!(value instanceof String)) {
                message.append(" of type ");
                message.append(value.getClass().getSimpleName());
            }
        }
        message.append(" as ");
        message.append(typeClass.getSimpleName());
        return this.error(message.toString(), cause);
    }
}

