/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.marshall.spi;

import io.github.mmm.base.number.NumberType;
import io.github.mmm.marshall.StructuredFormat;
import io.github.mmm.marshall.spi.AbstractStructuredReader;
import io.github.mmm.marshall.spi.StructuredNode;

public abstract class AbstractStructuredStringReader<S extends StructuredNode<S>>
extends AbstractStructuredReader<S> {
    public AbstractStructuredStringReader(StructuredFormat format) {
        super(format);
    }

    protected String readValueAsNumberString() {
        return this.readValueAsString();
    }

    @Override
    protected <N extends Number> N readValueAsNumber(NumberType<N> type) {
        String value = this.readValueAsNumberString();
        if (value == null) {
            return null;
        }
        try {
            return (N)type.parse(value);
        }
        catch (RuntimeException e) {
            throw this.error(value, type.getType(), e);
        }
    }
}

