/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.marshall.spi;

import io.github.mmm.base.number.NumberType;
import io.github.mmm.marshall.StructuredFormat;
import io.github.mmm.marshall.spi.AbstractStructuredReader;
import io.github.mmm.marshall.spi.StructuredNode;

public abstract class AbstractStructuredValueReader<S extends StructuredNode<S>>
extends AbstractStructuredReader<S> {
    public AbstractStructuredValueReader(StructuredFormat format) {
        super(format);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected <N extends Number> N readValueAsNumber(NumberType<N> numberType) {
        Object value = this.readValue();
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            Number result = numberType.valueOf((Number)value, true);
            if (result != null) return (N)result;
            if (numberType != NumberType.FLOAT || !(value instanceof Double)) throw this.error(value, numberType.getType());
            result = numberType.valueOf((Number)value, false);
            if (!value.toString().equals(result.toString())) throw this.error(value, numberType.getType());
            return (N)result;
        }
        if (!(value instanceof String)) throw this.error(value, numberType.getType());
        try {
            return (N)numberType.parse(value.toString());
        }
        catch (RuntimeException e) {
            throw this.error(value, numberType.getType(), e);
        }
    }
}

