/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.marshall.spi;

import io.github.mmm.marshall.EnumFormat;
import io.github.mmm.marshall.MarshallingConfig;
import io.github.mmm.marshall.StructuredFormat;
import io.github.mmm.marshall.StructuredReader;
import io.github.mmm.marshall.StructuredState;
import io.github.mmm.marshall.StructuredWriter;
import io.github.mmm.marshall.id.StructuredIdMappingObject;
import io.github.mmm.marshall.spi.AbstractStructuredProcessor;
import io.github.mmm.marshall.spi.AbstractStructuredReader;
import io.github.mmm.marshall.spi.StructuredNode;
import io.github.mmm.marshall.spi.StructuredNodeType;

public abstract class AbstractStructuredWriter<S extends StructuredNode<S>>
extends AbstractStructuredProcessor<S>
implements StructuredWriter {
    static final String XML_COMMENT_DASHES = "--";
    static final String XML_COMMENT_DASHES_ESCAPED = "\\-_-/";
    protected final boolean writeNullValues;
    protected final String indentation;
    protected int indentCount;

    public AbstractStructuredWriter(StructuredFormat format) {
        super(format);
        this.writeNullValues = (Boolean)this.config.get(MarshallingConfig.VAR_WRITE_NULL_VALUES);
        this.indentation = this.normalizeIndentation((String)this.config.get(MarshallingConfig.VAR_INDENTATION));
    }

    @Override
    public final void writeStartArray() {
        StructuredNodeType type = StructuredNodeType.ARRAY;
        this.doWriteStart(type, null);
        this.setState(StructuredState.START_ARRAY);
        this.node = this.newNode(type, null);
        ++this.indentCount;
    }

    @Override
    public final void writeStartObject(StructuredIdMappingObject object) {
        StructuredNodeType type = StructuredNodeType.OBJECT;
        this.doWriteStart(type, object);
        this.setState(StructuredState.START_OBJECT);
        this.node = this.newNode(type, object);
        ++this.indentCount;
    }

    protected abstract void doWriteStart(StructuredNodeType var1, StructuredIdMappingObject var2);

    @Override
    public final void writeEnd() {
        if (this.node.parent == null || this.node.type == null) {
            throw new IllegalStateException("Cannon end root or atomic value state - too many writeEnd calls!");
        }
        --this.indentCount;
        this.doWriteEnd(this.node.type);
        this.setState(this.node.type.getEnd());
        this.node = this.node.end();
    }

    protected abstract void doWriteEnd(StructuredNodeType var1);

    protected String normalizeIndentation(String indent) {
        return indent;
    }

    protected String escapeXmlComment(String currentComment) {
        return currentComment.replace(XML_COMMENT_DASHES, XML_COMMENT_DASHES_ESCAPED);
    }

    @Override
    public final void writeName(String newName) {
        this.writeName(newName, 0);
    }

    protected void writeName(String newName, int newId) {
        if (this.name != null) {
            throw new IllegalStateException("Cannot write name " + newName + " while previous name " + this.name + " has not been processed! Forgot to call writeStartObject?");
        }
        this.name = newName;
        this.setState(StructuredState.NAME);
    }

    @Override
    public void writeValueAsEnum(Enum<?> value) {
        if (value == null) {
            this.writeValueAsNull();
            return;
        }
        if (this.enumFormat == EnumFormat.ORDINAL) {
            this.writeValueAsInteger((Integer)value.ordinal());
        } else {
            this.writeValueAsString(this.enumFormat.toString(value));
        }
    }

    @Override
    public final void writeValueAsBoolean(Boolean value) {
        if (value == null) {
            this.writeValueAsNull();
        } else {
            this.writeValueAsBoolean((boolean)value);
        }
    }

    @Override
    public final void writeValueAsLong(Long value) {
        if (value == null) {
            this.writeValueAsNull();
        } else {
            this.writeValueAsLong((long)value);
        }
    }

    @Override
    public final void writeValueAsInteger(Integer value) {
        if (value == null) {
            this.writeValueAsNull();
        } else {
            this.writeValueAsInteger((int)value);
        }
    }

    @Override
    public final void writeValueAsDouble(Double value) {
        if (value == null) {
            this.writeValueAsNull();
        } else {
            this.writeValueAsDouble((double)value);
        }
    }

    @Override
    public final void writeValueAsFloat(Float value) {
        if (value == null) {
            this.writeValueAsNull();
        } else {
            this.writeValueAsFloat(value.floatValue());
        }
    }

    @Override
    public final void writeValueAsShort(Short value) {
        if (value == null) {
            this.writeValueAsNull();
        } else {
            this.writeValueAsShort((short)value);
        }
    }

    @Override
    public final void writeValueAsByte(Byte value) {
        if (value == null) {
            this.writeValueAsNull();
        } else {
            this.writeValueAsByte((byte)value);
        }
    }

    @Override
    public void write(StructuredReader reader2copyFrom) {
        AbstractStructuredReader reader = (AbstractStructuredReader)reader2copyFrom;
        boolean idBasedReader = reader.getFormat().isIdBased();
        boolean idBasedWriter = this.getFormat().isIdBased();
        boolean todo = true;
        while (todo) {
            StructuredState readerState;
            String comment = reader.readComment();
            if (comment != null) {
                this.writeComment(comment);
            }
            if ((readerState = reader.getState()) == StructuredState.NULL) {
                readerState = StructuredState.START_OBJECT;
            }
            if (readerState == StructuredState.START_OBJECT) {
                reader.readStartObject(reader);
                this.writeStartObject(reader);
                continue;
            }
            if (readerState == StructuredState.END_OBJECT) {
                reader.readEndObject();
                this.writeEnd();
                continue;
            }
            if (readerState == StructuredState.START_ARRAY) {
                reader.readStartArray();
                this.writeStartArray();
                continue;
            }
            if (readerState == StructuredState.END_ARRAY) {
                reader.readEndArray();
                this.writeEnd();
                continue;
            }
            if (readerState == StructuredState.NAME) {
                reader.next(false);
                if (idBasedReader && idBasedWriter) {
                    int id = reader.getId();
                    this.writeName("?", id);
                    continue;
                }
                this.writeName(reader.getName());
                continue;
            }
            if (readerState == StructuredState.VALUE) {
                Object value = reader.readValue();
                this.writeValue(value);
                continue;
            }
            if (readerState != StructuredState.DONE) continue;
            todo = false;
        }
    }
}

