/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.marshall.spi;

import io.github.mmm.marshall.spi.StructuredNodeType;

public abstract class StructuredNode<SELF extends StructuredNode<SELF>> {
    public final SELF parent;
    public final StructuredNodeType type;
    public int elementCount;

    public StructuredNode(SELF parent, StructuredNodeType type) {
        this.parent = parent;
        this.type = type;
    }

    public final boolean isRoot() {
        return this.parent == null;
    }

    public final boolean isTopObject() {
        return this.type == StructuredNodeType.OBJECT && ((StructuredNode)this.parent).parent == null;
    }

    public StructuredNodeType getType() {
        if (this.type == null && this.parent != null) {
            return ((StructuredNode)this.parent).type;
        }
        return this.type;
    }

    public SELF end() {
        return this.parent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        StructuredNode<SELF> node = this;
        do {
            if (!sb.isEmpty()) {
                sb.append(">");
            }
            if (node.type == null) {
                if (node.parent == null) {
                    sb.append("ROOT");
                    continue;
                }
                sb.append("VALUE");
                continue;
            }
            sb.append((Object)node.type);
        } while ((node = node.parent) != null);
        return sb.toString();
    }
}

