/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.marshall.standard;

import io.github.mmm.marshall.Marshalling;
import io.github.mmm.marshall.StructuredReader;
import io.github.mmm.marshall.StructuredWriter;
import io.github.mmm.marshall.impl.MashallingDatatypes;
import java.util.HashMap;
import java.util.Map;

public class DatatypeMarshalling<T>
implements Marshalling<T> {
    private static final Map<Class<?>, DatatypeMarshalling<?>> MARSHALLING_MAP = new HashMap();
    private final Class<T> type;

    protected DatatypeMarshalling(Class<T> type) {
        this.type = type;
    }

    @Override
    public void writeObject(StructuredWriter writer, T object) {
        writer.writeValue(object);
    }

    @Override
    public T readObject(StructuredReader reader) {
        return reader.readValue(this.type);
    }

    public static <T> DatatypeMarshalling<T> of(Class<T> type) {
        DatatypeMarshalling<Object> marshalling = MARSHALLING_MAP.get(type);
        if (marshalling == null) {
            if (!MashallingDatatypes.isSupported(type)) {
                throw new IllegalArgumentException(String.valueOf(type));
            }
            marshalling = new DatatypeMarshalling<T>(type);
            MARSHALLING_MAP.put(type, marshalling);
        }
        return marshalling;
    }
}

