/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.marshall.standard;

import io.github.mmm.marshall.Marshalling;
import io.github.mmm.marshall.StructuredReader;
import io.github.mmm.marshall.StructuredWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ListMarshalling<T>
implements Marshalling<Collection<T>> {
    private final Marshalling<T> itemMarshalling;

    public ListMarshalling(Marshalling<T> itemMarshalling) {
        Objects.requireNonNull(itemMarshalling);
        this.itemMarshalling = itemMarshalling;
    }

    @Override
    public void writeObject(StructuredWriter writer, Collection<T> list) {
        if (list == null) {
            writer.writeValueAsNull();
        } else {
            writer.writeStartArray();
            for (T item : list) {
                this.itemMarshalling.writeObject(writer, item);
            }
            writer.writeEnd();
        }
    }

    @Override
    public List<T> readObject(StructuredReader reader) {
        ArrayList list = null;
        if (reader.readStartArray()) {
            list = new ArrayList();
            while (!reader.readEnd()) {
                Object item = this.itemMarshalling.readObject(reader);
                list.add(item);
            }
        } else {
            Object value = reader.readValue();
            if (value != null) {
                throw new IllegalStateException(String.valueOf(value));
            }
        }
        return list;
    }
}

