/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.nls.argument;

import io.github.mmm.nls.argument.NlsArgumentsKeys;
import io.github.mmm.nls.argument.impl.NlsArgumentsDouble;
import io.github.mmm.nls.argument.impl.NlsArgumentsKeyValue;
import io.github.mmm.nls.argument.impl.NlsArgumentsMap;
import io.github.mmm.nls.argument.impl.NlsArgumentsMinMax;
import io.github.mmm.nls.argument.impl.NlsArgumentsNone;
import io.github.mmm.nls.argument.impl.NlsArgumentsObjectKey;
import io.github.mmm.nls.argument.impl.NlsArgumentsSingle;
import java.util.HashMap;
import java.util.Map;

public interface NlsArguments
extends NlsArgumentsKeys {
    public Object get(String var1);

    public String getKey(int var1);

    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public NlsArguments with(String var1, Object var2);

    public static NlsArguments of() {
        return NlsArgumentsNone.INSTANCE;
    }

    public static NlsArguments of(Map<String, Object> map) {
        int size = map.size();
        if (size == 0) {
            return NlsArguments.of();
        }
        if (size == 1) {
            Map.Entry<String, Object> entry = map.entrySet().iterator().next();
            return NlsArguments.of(entry.getKey(), entry.getValue());
        }
        return new NlsArgumentsMap(map);
    }

    public static NlsArguments of(String key, Object value) {
        return new NlsArgumentsSingle(key, value);
    }

    public static NlsArguments of(String key1, Object value1, String key2, Object value2) {
        return new NlsArgumentsDouble(key1, value1, key2, value2);
    }

    public static NlsArguments of(String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        return new NlsArgumentsMap(map);
    }

    public static NlsArguments ofValue(Object value) {
        return NlsArguments.of("value", value);
    }

    public static NlsArguments ofObject(Object value) {
        return NlsArguments.of("object", value);
    }

    public static NlsArguments ofArgument(Object value) {
        return NlsArguments.of("argument", value);
    }

    public static NlsArguments ofDefault(Object value) {
        return NlsArguments.of("default", value);
    }

    public static NlsArguments ofDate(Object value) {
        return NlsArguments.of("date", value);
    }

    public static NlsArguments ofFile(Object value) {
        return NlsArguments.of("file", value);
    }

    public static NlsArguments ofName(Object value) {
        return NlsArguments.of("name", value);
    }

    public static NlsArguments ofType(Object value) {
        return NlsArguments.of("type", value);
    }

    public static NlsArguments ofFormat(Object value) {
        return NlsArguments.of("format", value);
    }

    public static NlsArguments ofKey(Object value) {
        return NlsArguments.of("default", value);
    }

    public static NlsArguments ofKeyValue(Object key, Object value) {
        return new NlsArgumentsKeyValue(key, value);
    }

    public static NlsArguments ofObjectKey(Object object, Object key) {
        return new NlsArgumentsObjectKey(object, key);
    }

    public static NlsArguments ofMinMax(Object min, Object max) {
        return new NlsArgumentsMinMax(min, max);
    }

    public static NlsArguments ofValueMinMax(Object value, Object min, Object max) {
        return NlsArguments.of("value", value, "min", min, "max", max);
    }
}

