/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.nls.formatter.impl;

import io.github.mmm.base.filter.CharFilter;
import io.github.mmm.base.filter.ListCharFilter;
import io.github.mmm.nls.formatter.NlsFormatterManager;
import io.github.mmm.nls.formatter.NlsFormatterPlugin;
import io.github.mmm.nls.formatter.impl.ConfiguredNlsFormatterMap;
import io.github.mmm.nls.formatter.impl.NlsFormatterMap;
import io.github.mmm.nls.formatter.impl.plugin.NlsFormatterPluginChoice;
import io.github.mmm.nls.formatter.impl.plugin.NlsFormatterPluginDatePattern;
import io.github.mmm.nls.formatter.impl.plugin.NlsFormatterPluginNumberPattern;
import io.github.mmm.scanner.CharSequenceScanner;

public class NlsFormatterManagerImpl
implements NlsFormatterManager {
    public static final NlsFormatterManagerImpl INSTANCE = new NlsFormatterManagerImpl();
    protected static final CharFilter NO_COMMA_OR_END_EXPRESSION = new ListCharFilter(",}").negate();
    protected static final CharFilter NO_EXPRESSION = new ListCharFilter("{}").negate();
    private final NlsFormatterMap formatterMap;

    public NlsFormatterManagerImpl() {
        this(new ConfiguredNlsFormatterMap());
    }

    public NlsFormatterManagerImpl(NlsFormatterMap formatterMap) {
        this.formatterMap = formatterMap;
    }

    @Override
    public NlsFormatterPlugin getFormatter(String formatType, CharSequenceScanner scanner) {
        if ("choice".equals(formatType)) {
            return new NlsFormatterPluginChoice(scanner);
        }
        String formatStyle = scanner.readWhile(NO_EXPRESSION);
        return this.getFormatter(formatType, formatStyle);
    }

    protected NlsFormatterPlugin getSubFormatter(String formatType, String subformat) {
        if ("number".equals(formatType)) {
            return new NlsFormatterPluginNumberPattern(subformat);
        }
        if ("date".equals(formatType) || "time".equals(formatType) || "datetime".equals(formatType)) {
            return new NlsFormatterPluginDatePattern(subformat);
        }
        return null;
    }

    @Override
    public NlsFormatterPlugin getFormatter(String formatType, String formatStyle) {
        NlsFormatterPlugin result = null;
        result = this.formatterMap.getFormatter(formatType, formatStyle);
        if (result == null && formatStyle != null && (result = this.getSubFormatter(formatType, formatStyle)) == null) {
            result = this.formatterMap.getFormatter(formatType, null);
        }
        if (result == null && formatType == null) {
            throw new IllegalStateException();
        }
        return result;
    }

    protected NlsFormatterMap getFormatterMap() {
        return this.formatterMap;
    }
}

