/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.nls.formatter.impl;

import io.github.mmm.nls.formatter.NlsFormatter;
import io.github.mmm.nls.formatter.NlsFormatterPlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class NlsFormatterMap {
    private final Map<String, Map<String, NlsFormatterPlugin>> builders = new HashMap<String, Map<String, NlsFormatterPlugin>>();

    public NlsFormatter<?> registerFormatter(NlsFormatterPlugin formatter) {
        return this.registerFormatter(formatter, formatter.getType(), formatter.getStyle());
    }

    public NlsFormatter<?> registerFormatter(NlsFormatterPlugin formatter, String formatType, String formatStyle) {
        Map<String, NlsFormatterPlugin> style2builderMap;
        Objects.requireNonNull(formatter, "formatter");
        if (formatStyle != null) {
            Objects.requireNonNull(formatType, "formatType");
        }
        if ((style2builderMap = this.builders.get(formatType)) == null) {
            style2builderMap = new HashMap<String, NlsFormatterPlugin>();
            this.builders.put(formatType, style2builderMap);
        }
        return style2builderMap.put(formatStyle, formatter);
    }

    public NlsFormatterPlugin getFormatter(String formatType, String formatStyle) {
        NlsFormatterPlugin result = null;
        Map<String, NlsFormatterPlugin> style2builderMap = this.builders.get(formatType);
        if (style2builderMap != null && (result = style2builderMap.get(formatStyle)) == null && formatStyle == null) {
            result = style2builderMap.get("medium");
        }
        return result;
    }
}

