/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.nls.formatter.impl;

import io.github.mmm.nls.argument.NlsArguments;
import io.github.mmm.nls.formatter.NlsMessageFormatter;
import io.github.mmm.nls.formatter.NlsVariableFormatter;
import io.github.mmm.nls.formatter.impl.AbstractNlsFormatter;
import io.github.mmm.nls.variable.NlsVariable;
import io.github.mmm.nls.variable.NlsVariableParser;
import io.github.mmm.scanner.CharSequenceScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;

public class NlsMessageFormatterImpl
extends AbstractNlsFormatter<Void>
implements NlsMessageFormatter {
    private final PatternSegment[] segments;
    private final String suffix;

    public NlsMessageFormatterImpl(String pattern) {
        ArrayList<PatternSegment> segmentList = new ArrayList<PatternSegment>();
        CharSequenceScanner scanner = new CharSequenceScanner(pattern);
        String prefix = scanner.readUntil(123, true, 92);
        while (scanner.hasNext()) {
            NlsVariable variable;
            int index = scanner.getCurrentIndex() - 1;
            try {
                variable = NlsVariableParser.get().parse(scanner);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(scanner.substring(index, scanner.getCurrentIndex()), e);
            }
            PatternSegment segment = new PatternSegment(prefix, variable);
            segmentList.add(segment);
            prefix = scanner.readUntil(123, true, 92);
        }
        this.suffix = prefix;
        this.segments = segmentList.toArray(new PatternSegment[segmentList.size()]);
    }

    @Override
    public final void doFormat(Void nothing, Locale locale, NlsArguments arguments, Appendable buffer) throws IOException {
        for (PatternSegment segment : this.segments) {
            buffer.append(segment.prefix);
            NlsVariableFormatter.get().format(segment.variable, locale, arguments, buffer);
        }
        buffer.append(this.suffix);
    }

    public String getSuffix() {
        return this.suffix;
    }

    protected static class PatternSegment {
        private final String prefix;
        private final NlsVariable variable;

        public PatternSegment(String prefix, NlsVariable variable) {
            this.prefix = prefix;
            this.variable = variable;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public NlsVariable getVariable() {
            return this.variable;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.prefix);
            sb.append(this.variable);
            return sb.toString();
        }
    }
}

