/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.nls.formatter.impl.plugin;

import io.github.mmm.base.compare.CompareOperator;
import io.github.mmm.base.filter.CharFilter;
import io.github.mmm.base.filter.ListCharFilter;
import io.github.mmm.nls.argument.NlsArguments;
import io.github.mmm.nls.formatter.NlsVariableFormatter;
import io.github.mmm.nls.formatter.impl.plugin.AbstractNlsFormatterPlugin;
import io.github.mmm.nls.variable.NlsVariable;
import io.github.mmm.nls.variable.NlsVariableParser;
import io.github.mmm.scanner.CharSequenceScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;

public class NlsFormatterPluginChoice
extends AbstractNlsFormatterPlugin {
    public static final char CONDITION_START = '(';
    public static final char CONDITION_END = ')';
    public static final char CONDITION_VAR = '?';
    public static final String CONDITION_ELSE = "else";
    private static final Predicate<Object> FILTER_ELSE = new Condition(null, null);
    private static final CharFilter FILTER_COMPARATOR = new ListCharFilter("<=>!");
    private static final CharFilter FILTER_COMPARATOR_ARGUMENT = CharFilter.LATIN_LETTER_OR_DIGIT.compose((CharFilter)new ListCharFilter("-+.:"));
    private final List<Choice> choices = new ArrayList<Choice>();

    public NlsFormatterPluginChoice(CharSequenceScanner scanner) {
        boolean hasElse = false;
        int cp = scanner.peek();
        while (cp == 40 && !hasElse) {
            scanner.next();
            Choice choice = this.parseChoice(scanner);
            if (choice.condition == FILTER_ELSE) {
                hasElse = true;
            }
            this.choices.add(choice);
            cp = scanner.peek();
        }
        if (!hasElse) {
            throw new IllegalStateException("no (else) condition!");
        }
        if (this.choices.size() < 2) {
            throw new IllegalStateException("only (else) condition!");
        }
    }

    private Choice parseChoice(CharSequenceScanner scanner) {
        Predicate<Object> condition = this.parseCondition(scanner);
        ArrayList<Segment> segments = new ArrayList<Segment>();
        while (scanner.hasNext()) {
            int index = scanner.getCurrentIndex();
            int cp = scanner.peek();
            String literal = null;
            if (cp == 34 || cp == 39) {
                scanner.next();
                literal = scanner.readUntil(cp, false, cp);
                if (literal == null) {
                    throw new IllegalArgumentException(scanner.substring(index, scanner.getCurrentIndex()));
                }
                cp = scanner.peek();
            }
            NlsVariable variable = null;
            if (cp == 123) {
                scanner.next();
                variable = NlsVariableParser.get().parse(scanner);
            }
            if (variable == null && literal == null) break;
            segments.add(new Segment(literal, variable));
        }
        return new Choice(condition, segments);
    }

    private Predicate<Object> parseCondition(CharSequenceScanner scanner) {
        Condition condition;
        int index = scanner.getCurrentIndex();
        if (scanner.expectOne(63)) {
            String symbol = scanner.readWhile(FILTER_COMPARATOR);
            CompareOperator comparator = CompareOperator.ofSymbol((String)symbol);
            if (comparator == null) {
                throw new IllegalArgumentException(symbol);
            }
            Comparable<?> comparatorArgument = this.parseComparatorArgument(scanner);
            condition = new Condition(comparator, comparatorArgument);
        } else if (scanner.expectUnsafe(CONDITION_ELSE, false)) {
            condition = FILTER_ELSE;
        } else {
            throw new IllegalArgumentException(scanner.substring(index, scanner.getCurrentIndex()));
        }
        if (!scanner.expectOne(41)) {
            throw new IllegalArgumentException(scanner.substring(index, scanner.getCurrentIndex()));
        }
        return condition;
    }

    private Comparable<?> parseComparatorArgument(CharSequenceScanner scanner) {
        Comparable<Boolean> comparatorArgument;
        int index = scanner.getCurrentIndex();
        int cp = scanner.peek();
        if (cp == 34 || cp == 39) {
            scanner.next();
            comparatorArgument = scanner.readUntil(cp, false, cp);
        } else {
            String argument = scanner.readWhile(FILTER_COMPARATOR_ARGUMENT);
            if (argument.length() == 0) {
                throw new IllegalArgumentException(scanner.substring(index, scanner.getCurrentIndex()));
            }
            comparatorArgument = "null".equals(argument) ? null : ("true".equals(argument) ? Boolean.TRUE : ("false".equals(argument) ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)Double.valueOf(argument)));
        }
        return comparatorArgument;
    }

    @Override
    public void doFormat(Object object, Locale locale, NlsArguments arguments, Appendable buffer) throws IOException {
        for (Choice choice : this.choices) {
            if (!choice.condition.test(object)) continue;
            for (Segment segment : choice.segments) {
                buffer.append(segment.literal);
                if (segment.variable == null) continue;
                NlsVariableFormatter.get().format(segment.variable, locale, arguments, buffer);
            }
            return;
        }
        buffer.append(this.toString());
    }

    @Override
    public String getType() {
        return "choice";
    }

    @Override
    public String getStyle() {
        return null;
    }

    public List<Choice> getChoices() {
        return this.choices;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("choice");
        sb.append(",");
        for (Choice choice : this.choices) {
            sb.append(choice);
        }
        return sb.toString();
    }

    public static final class Choice {
        private final Predicate<Object> condition;
        private final List<Segment> segments;

        private Choice(Predicate<Object> condition, List<Segment> segments) {
            this.condition = condition;
            this.segments = segments;
        }

        public Predicate<Object> getCondition() {
            return this.condition;
        }

        public boolean isElse() {
            return this.condition == FILTER_ELSE;
        }

        public List<Segment> getSegments() {
            return this.segments;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.condition);
            for (Segment segment : this.segments) {
                buffer.append('\'');
                buffer.append(segment.literal.replace("'", "''"));
                buffer.append('\'');
                if (segment.variable == null) continue;
                buffer.append(segment.variable);
            }
            return buffer.toString();
        }
    }

    public static class Segment {
        private final String literal;
        private final NlsVariable variable;

        public Segment(String literal, NlsVariable variable) {
            this.literal = literal == null ? "" : literal;
            this.variable = variable;
        }

        public String getLiteral() {
            return this.literal;
        }

        public NlsVariable getVariable() {
            return this.variable;
        }
    }

    private static class Condition
    implements Predicate<Object> {
        private final CompareOperator comparator;
        private final Comparable comparatorArgument;
        private final double numericArgument;

        public Condition(CompareOperator comparator, Comparable comparatorArgument) {
            this.comparator = comparator;
            if (comparatorArgument instanceof Double) {
                this.comparatorArgument = null;
                this.numericArgument = (Double)comparatorArgument;
            } else {
                this.comparatorArgument = comparatorArgument;
                this.numericArgument = 0.0;
            }
        }

        @Override
        public boolean test(Object value) {
            if (this.comparator == null) {
                return true;
            }
            if (this.comparatorArgument == null) {
                if (value instanceof Number) {
                    return this.comparator.evalDouble(((Number)value).doubleValue(), this.numericArgument);
                }
                return false;
            }
            return this.comparator.evalObject(value, (Object)this.comparatorArgument);
        }

        public String toString() {
            if (this.comparator == null) {
                return "(else)";
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append("(?");
            buffer.append(this.comparator.getSymbol());
            if (this.comparatorArgument == null) {
                buffer.append(this.numericArgument);
            } else {
                buffer.append(this.comparatorArgument);
            }
            buffer.append(")");
            return buffer.toString();
        }
    }
}

